/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.metrics;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Counter;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.Meter;
import com.couchbase.client.core.cnc.ValueRecorder;
import com.couchbase.client.core.cnc.events.metrics.LatencyMetricsAggregatedEvent;
import com.couchbase.client.core.cnc.metrics.AggregatingCounter;
import com.couchbase.client.core.cnc.metrics.AggregatingValueRecorder;
import com.couchbase.client.core.cnc.metrics.NameAndTags;
import com.couchbase.client.core.deps.org.HdrHistogram.Histogram;
import com.couchbase.client.core.env.LoggingMeterConfig;
import com.couchbase.client.core.error.MeterException;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.core.publisher.Mono;

@Stability.Volatile
public class LoggingMeter
implements Meter {
    private static final AtomicInteger METER_ID = new AtomicInteger();
    private final EventBus eventBus;
    private final Thread worker;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Map<NameAndTags, AggregatingValueRecorder> valueRecorders = new ConcurrentHashMap<NameAndTags, AggregatingValueRecorder>();
    private final long emitIntervalMs;
    private final LoggingMeterConfig config;

    public static LoggingMeter create(EventBus eventBus, LoggingMeterConfig config) {
        return new LoggingMeter(config, eventBus);
    }

    private LoggingMeter(LoggingMeterConfig config, EventBus eventBus) {
        this.eventBus = eventBus;
        this.emitIntervalMs = config.emitInterval().toMillis();
        this.config = config;
        this.worker = new Thread(new Worker());
        this.worker.setDaemon(true);
    }

    public LoggingMeterConfig config() {
        return this.config;
    }

    @Override
    public Counter counter(String name, Map<String, String> tags) {
        return AggregatingCounter.INSTANCE;
    }

    @Override
    public synchronized ValueRecorder valueRecorder(String name, Map<String, String> tags) {
        try {
            return this.valueRecorders.computeIfAbsent(new NameAndTags(name, tags), key -> new AggregatingValueRecorder(name, tags));
        }
        catch (Exception ex) {
            throw new MeterException("Failed to create/access ValueRecorder", ex);
        }
    }

    @Override
    public Mono<Void> start() {
        return Mono.defer(() -> {
            if (this.running.compareAndSet(false, true)) {
                this.worker.start();
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<Void> stop(Duration timeout) {
        return Mono.defer(() -> {
            if (this.running.compareAndSet(true, false)) {
                this.worker.interrupt();
            }
            return Mono.empty();
        });
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName("cb-metrics-" + METER_ID.incrementAndGet());
            while (LoggingMeter.this.running.get()) {
                try {
                    Thread.sleep(LoggingMeter.this.emitIntervalMs);
                    this.dumpMetrics();
                }
                catch (InterruptedException ex) {
                    if (!LoggingMeter.this.running.get()) {
                        return;
                    }
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {}
            }
        }

        private synchronized void dumpMetrics() {
            HashMap<String, Object> output = new HashMap<String, Object>();
            HashMap<String, Long> meta = new HashMap<String, Long>();
            meta.put("emit_interval_s", TimeUnit.MILLISECONDS.toSeconds(LoggingMeter.this.emitIntervalMs));
            output.put("meta", meta);
            boolean wroteRow = false;
            HashMap<String, Map> operations = new HashMap<String, Map>();
            for (Map.Entry entry : LoggingMeter.this.valueRecorders.entrySet()) {
                AggregatingValueRecorder avr;
                Histogram histogram;
                if (!((NameAndTags)entry.getKey()).name().equals("db.couchbase.operations") || (histogram = (avr = (AggregatingValueRecorder)entry.getValue()).clearStats()).getTotalCount() == 0L) continue;
                wroteRow = true;
                String service = avr.tags().get("db.couchbase.service");
                String operation = avr.tags().get("db.operation");
                Map serviceMap = operations.computeIfAbsent(service, k -> new HashMap());
                Map operationMap = (Map)serviceMap.computeIfAbsent(operation, k -> new HashMap());
                operationMap.put("total_count", histogram.getTotalCount());
                LinkedHashMap<String, Double> percentiles = new LinkedHashMap<String, Double>();
                percentiles.put("50.0", (double)histogram.getValueAtPercentile(50.0) / 1000.0);
                percentiles.put("90.0", (double)histogram.getValueAtPercentile(90.0) / 1000.0);
                percentiles.put("99.0", (double)histogram.getValueAtPercentile(99.0) / 1000.0);
                percentiles.put("99.9", (double)histogram.getValueAtPercentile(99.9) / 1000.0);
                percentiles.put("100.0", (double)histogram.getMaxValue() / 1000.0);
                operationMap.put("percentiles_us", percentiles);
            }
            output.put("operations", operations);
            if (wroteRow) {
                LoggingMeter.this.eventBus.publish(new LatencyMetricsAggregatedEvent(Duration.ofMillis(LoggingMeter.this.emitIntervalMs), output));
            }
        }
    }
}

