/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.chunk;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.channel.ChannelConfig;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpResponse;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.io.netty.chunk.ChunkResponseParser;
import com.couchbase.client.core.json.stream.CopyingStreamWindow;
import com.couchbase.client.core.json.stream.JsonStreamParser;
import com.couchbase.client.core.msg.RequestContext;
import com.couchbase.client.core.msg.chunk.ChunkHeader;
import com.couchbase.client.core.msg.chunk.ChunkRow;
import com.couchbase.client.core.msg.chunk.ChunkTrailer;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public abstract class BaseChunkResponseParser<H extends ChunkHeader, ROW extends ChunkRow, T extends ChunkTrailer>
implements ChunkResponseParser<H, ROW, T> {
    private JsonStreamParser parser;
    private final ByteBuf scratchBuffer = Unpooled.unreleasableBuffer(Unpooled.buffer());
    private CouchbaseException decodingFailure;
    private boolean headerComplete;
    private ChannelConfig channelConfig;
    private MonoProcessor<T> trailer;
    private FluxProcessor<ROW, ROW> rows;
    private FluxSink<ROW> rowSink;
    private final AtomicLong requested = new AtomicLong(0L);
    private volatile RequestContext requestContext;
    private volatile HttpResponse responseHeader;

    protected abstract JsonStreamParser.Builder parserBuilder();

    @Override
    public final void cleanup() {
        if (this.parser != null) {
            this.parser.close();
        }
        this.parser = null;
        this.decodingFailure = null;
        this.headerComplete = false;
        this.doCleanup();
    }

    @Override
    public void updateRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    protected RequestContext requestContext() {
        return this.requestContext;
    }

    @Override
    public void updateResponseHeader(HttpResponse responseHeader) {
        this.responseHeader = responseHeader;
    }

    protected HttpResponse responseHeader() {
        return this.responseHeader;
    }

    protected void markHeaderComplete() {
        this.headerComplete = true;
    }

    protected boolean isHeaderComplete() {
        return this.headerComplete;
    }

    protected abstract void doCleanup();

    @Override
    public void feed(ByteBuf input) {
        if (this.decodingFailure != null) {
            return;
        }
        try {
            this.parser.feed(input);
        }
        catch (DecodingFailureException e) {
            this.decodingFailure = e;
            this.failRows(e);
            this.failTrailer(e);
        }
    }

    @Override
    public void initialize(ChannelConfig channelConfig) {
        this.cleanup();
        this.parser = this.parserBuilder().build(this.scratchBuffer, new CopyingStreamWindow(channelConfig.getAllocator()));
        this.channelConfig = channelConfig;
        this.trailer = MonoProcessor.create();
        this.requested.set(0L);
        this.rows = EmitterProcessor.create();
        this.rowSink = this.rows.sink(FluxSink.OverflowStrategy.BUFFER).onRequest(v -> {
            this.requested.addAndGet(v);
            if (!channelConfig.isAutoRead()) {
                channelConfig.setAutoRead(true);
            }
        }).onDispose(() -> channelConfig.setAutoRead(true));
    }

    @Override
    public Flux<ROW> rows() {
        return this.rows;
    }

    @Override
    public Mono<T> trailer() {
        return this.trailer;
    }

    @Override
    public void endOfInput() {
        if (this.decodingFailure != null) {
            return;
        }
        try {
            this.parser.endOfInput();
        }
        catch (DecodingFailureException e) {
            this.decodingFailure = e;
            this.failRows(e);
            this.failTrailer(e);
            return;
        }
        this.signalComplete();
    }

    @Override
    public Optional<CouchbaseException> decodingFailure() {
        return Optional.ofNullable(this.decodingFailure);
    }

    protected abstract void signalComplete();

    protected void emitRow(ROW row) {
        this.rowSink.next(row);
        this.requested.decrementAndGet();
        if (this.requested.get() <= 0L && this.channelConfig.isAutoRead() && this.rows.downstreamCount() > 0L) {
            this.channelConfig.setAutoRead(false);
        }
    }

    protected void failRows(Throwable t) {
        this.rowSink.error(t);
    }

    protected void completeRows() {
        this.rowSink.complete();
    }

    private void failTrailer(Throwable t) {
        this.trailer.onError(t);
    }

    protected void completeTrailer(T trailer) {
        this.trailer.onNext(trailer);
        this.trailer.onComplete();
    }
}

