/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.json.stream;

import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonToken;
import com.couchbase.client.core.json.stream.JsonStreamParser;
import com.couchbase.client.core.json.stream.PathTree;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.function.Consumer;

class StructureNavigator {
    private final Scope objectScope = new ObjectScope();
    private final Scope arrayScope = new ArrayScope();
    private final State readingValue = new ReadingValue();
    private final State fastForwardObject = new FastForwarding(JsonToken.START_OBJECT, JsonToken.END_OBJECT);
    private final State fastForwardArray = new FastForwarding(JsonToken.START_ARRAY, JsonToken.END_ARRAY);
    private State state;
    private Mode mode = Mode.SCAN;
    private PathTree pathTree;
    private final Deque<Scope> scopeStack = new ArrayDeque<Scope>();
    private final JsonStreamParser parser;

    StructureNavigator(JsonStreamParser parser, PathTree pathTree) {
        this.pathTree = Objects.requireNonNull(pathTree);
        this.parser = Objects.requireNonNull(parser);
        this.pushScope(new RootScope());
    }

    public void accept(JsonToken token) {
        this.state.accept(token);
    }

    boolean isCapturing() {
        return this.mode == Mode.CAPTURE;
    }

    private void pushScope(Scope newScope) {
        this.scopeStack.push(newScope);
        this.transitionTo(newScope);
    }

    private void popScope() {
        this.scopeStack.pop();
        this.transitionTo(this.currentScope());
    }

    private State transitionTo(State newState) {
        this.state = newState;
        return newState;
    }

    private Scope currentScope() {
        return this.scopeStack.getFirst();
    }

    private void climbPathTree() {
        if (this.mode == Mode.SKIP) {
            this.mode = Mode.SCAN;
        } else {
            this.pathTree = this.pathTree.parent();
        }
    }

    private void descendPathTree() {
        if (this.mode == Mode.SKIP) {
            throw new IllegalStateException("Can't call this when mode is " + (Object)((Object)Mode.SKIP));
        }
        String fieldName = this.currentScope().getCurrentName();
        PathTree subtree = this.pathTree.subtree(fieldName).orElse(null);
        if (subtree == null) {
            this.mode = Mode.SKIP;
        } else {
            this.pathTree = subtree;
            if (subtree.callback().isPresent()) {
                this.mode = Mode.CAPTURE;
                this.parser.beginCapture();
            } else {
                this.mode = Mode.SCAN;
            }
        }
    }

    private void finishValue() {
        if (this.mode == Mode.CAPTURE) {
            this.mode = Mode.SCAN;
            this.parser.emitCapturedValue(this.pathTree.jsonPointer(), this.pathTree.callback().orElseThrow(() -> new AssertionError((Object)("missing callback for path tree " + this.pathTree))));
        }
        this.transitionTo(this.currentScope());
        this.climbPathTree();
    }

    private class FastForwarding
    implements State {
        private final JsonToken startToken;
        private final JsonToken endToken;
        private int depth;

        private FastForwarding(JsonToken startToken, JsonToken endToken) {
            this.startToken = Objects.requireNonNull(startToken);
            this.endToken = Objects.requireNonNull(endToken);
        }

        @Override
        public void accept(JsonToken token) {
            if (token == this.startToken) {
                ++this.depth;
            } else if (token == this.endToken) {
                --this.depth;
                if (this.depth == 0) {
                    StructureNavigator.this.finishValue();
                }
            }
        }
    }

    private class ReadingValue
    implements State {
        private ReadingValue() {
        }

        @Override
        public void accept(JsonToken token) {
            StructureNavigator.this.descendPathTree();
            switch (token) {
                case START_ARRAY: {
                    this.readContainer(token, StructureNavigator.this.arrayScope, StructureNavigator.this.fastForwardArray);
                    break;
                }
                case START_OBJECT: {
                    this.readContainer(token, StructureNavigator.this.objectScope, StructureNavigator.this.fastForwardObject);
                    return;
                }
                default: {
                    StructureNavigator.this.finishValue();
                }
            }
        }

        private void readContainer(JsonToken startToken, Scope scope, State fastForward) {
            if (StructureNavigator.this.mode == Mode.CAPTURE || StructureNavigator.this.mode == Mode.SKIP) {
                StructureNavigator.this.transitionTo(fastForward).accept(startToken);
            } else {
                StructureNavigator.this.pushScope(scope);
            }
        }
    }

    private class ArrayScope
    implements Scope {
        private ArrayScope() {
        }

        @Override
        public String getCurrentName() {
            return "-";
        }

        @Override
        public void accept(JsonToken token) {
            switch (token) {
                case END_ARRAY: {
                    StructureNavigator.this.finishValue();
                    StructureNavigator.this.popScope();
                    return;
                }
            }
            StructureNavigator.this.transitionTo(StructureNavigator.this.readingValue).accept(token);
        }
    }

    private class ObjectScope
    implements Scope {
        private ObjectScope() {
        }

        @Override
        public String getCurrentName() {
            try {
                String currentName = StructureNavigator.this.parser.getCurrentName();
                return currentName == null ? "" : currentName;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void accept(JsonToken token) {
            switch (token) {
                case FIELD_NAME: {
                    StructureNavigator.this.transitionTo(StructureNavigator.this.readingValue);
                    return;
                }
                case END_OBJECT: {
                    StructureNavigator.this.finishValue();
                    StructureNavigator.this.popScope();
                    return;
                }
            }
            throw new AssertionError((Object)("Unexpected token: " + (Object)((Object)token)));
        }
    }

    private class RootScope
    implements Scope {
        private RootScope() {
        }

        @Override
        public String getCurrentName() {
            return "";
        }

        @Override
        public void accept(JsonToken token) {
            StructureNavigator.this.transitionTo(StructureNavigator.this.readingValue).accept(token);
        }
    }

    private static enum Mode {
        SCAN,
        SKIP,
        CAPTURE;

    }

    static interface Scope
    extends State {
        public String getCurrentName();
    }

    static interface State
    extends Consumer<JsonToken> {
    }
}

