/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.events.core.DnsSrvLookupDisabledEvent;
import com.couchbase.client.core.cnc.events.core.DnsSrvLookupFailedEvent;
import com.couchbase.client.core.cnc.events.core.DnsSrvRecordsLoadedEvent;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.core.util.DnsSrv;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.naming.NameNotFoundException;

@Stability.Internal
public class ConnectionStringUtil {
    private ConnectionStringUtil() {
    }

    public static Set<SeedNode> seedNodesFromConnectionString(String cs, boolean dnsSrvEnabled, boolean tlsEnabled, EventBus eventBus) {
        ConnectionString connectionString = ConnectionString.create(cs);
        if (dnsSrvEnabled && connectionString.isValidDnsSrv()) {
            String srvHostname = connectionString.hosts().get(0).hostname();
            long start = System.nanoTime();
            try {
                if (srvHostname.startsWith("_couchbase._tcp.")) {
                    srvHostname = srvHostname.replace("_couchbase._tcp.", "");
                } else if (srvHostname.startsWith("_couchbases._tcp.")) {
                    srvHostname = srvHostname.replace("_couchbases._tcp.", "");
                }
                List<String> foundNodes = DnsSrv.fromDnsSrv(srvHostname, false, tlsEnabled);
                if (foundNodes.isEmpty()) {
                    throw new IllegalStateException("The loaded DNS SRV list from " + srvHostname + " is empty!");
                }
                Duration took = Duration.ofNanos(System.nanoTime() - start);
                eventBus.publish(new DnsSrvRecordsLoadedEvent(took, foundNodes));
                return foundNodes.stream().map(SeedNode::create).collect(Collectors.toSet());
            }
            catch (Throwable t) {
                Duration took = Duration.ofNanos(System.nanoTime() - start);
                if (t instanceof NameNotFoundException) {
                    eventBus.publish(new DnsSrvLookupFailedEvent(Event.Severity.INFO, took, null, DnsSrvLookupFailedEvent.Reason.NAME_NOT_FOUND));
                } else if (t.getCause() instanceof SocketTimeoutException) {
                    eventBus.publish(new DnsSrvLookupFailedEvent(Event.Severity.INFO, took, null, DnsSrvLookupFailedEvent.Reason.TIMED_OUT));
                } else {
                    eventBus.publish(new DnsSrvLookupFailedEvent(Event.Severity.WARN, took, t, DnsSrvLookupFailedEvent.Reason.OTHER));
                }
                return ConnectionStringUtil.populateSeedsFromConnectionString(connectionString);
            }
        }
        eventBus.publish(new DnsSrvLookupDisabledEvent(dnsSrvEnabled, connectionString.isValidDnsSrv()));
        return ConnectionStringUtil.populateSeedsFromConnectionString(connectionString);
    }

    private static Set<SeedNode> populateSeedsFromConnectionString(ConnectionString connectionString) {
        LinkedHashMap aggregated = new LinkedHashMap();
        for (ConnectionString.UnresolvedSocket socket : connectionString.hosts()) {
            if (!aggregated.containsKey(socket.hostname())) {
                aggregated.put(socket.hostname(), new ArrayList());
            }
            ((List)aggregated.get(socket.hostname())).add(socket);
        }
        Set<SeedNode> seedNodes = aggregated.entrySet().stream().map(entry -> {
            String hostname = (String)entry.getKey();
            Optional<Integer> kvPort = Optional.empty();
            Optional<Integer> managerPort = Optional.empty();
            for (ConnectionString.UnresolvedSocket socket : (List)entry.getValue()) {
                if (socket.portType().isPresent()) {
                    if (socket.portType().get() == ConnectionString.PortType.KV) {
                        kvPort = Optional.of(socket.port());
                        continue;
                    }
                    if (socket.portType().get() != ConnectionString.PortType.MANAGER) continue;
                    managerPort = Optional.of(socket.port());
                    continue;
                }
                if (socket.port() == 0) continue;
                kvPort = Optional.of(socket.port());
            }
            return SeedNode.create(hostname, kvPort, managerPort);
        }).collect(Collectors.toSet());
        ConnectionStringUtil.sanityCheckSeedNodes(connectionString.original(), seedNodes);
        return seedNodes;
    }

    private static void sanityCheckSeedNodes(String connectionString, Set<SeedNode> seedNodes) {
        for (SeedNode seedNode : seedNodes) {
            if (!seedNode.kvPort().isPresent() || seedNode.kvPort().get() != 8091 && seedNode.kvPort().get() != 18091) continue;
            String recommended = connectionString.replace(":8091", "").replace(":18091", "");
            throw new InvalidArgumentException("Specifying 8091 or 18091 in the connection string \"" + connectionString + "\" is likely not what you want (it would connect to key/value via the management port which does not work). Please omit the port and use \"" + recommended + "\" instead.", null, null);
        }
    }
}

