/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Stability.Internal
public class UrlQueryStringBuilder {
    private final Map<String, List<String>> params = new LinkedHashMap<String, List<String>>();
    private final boolean encodeNames;

    public static UrlQueryStringBuilder createForUrlSafeNames() {
        return new UrlQueryStringBuilder(false);
    }

    public static UrlQueryStringBuilder create() {
        return new UrlQueryStringBuilder(true);
    }

    private UrlQueryStringBuilder(boolean encodeNames) {
        this.encodeNames = encodeNames;
    }

    private UrlQueryStringBuilder setSafeValue(String name, String value) {
        ArrayList<String> values = new ArrayList<String>(1);
        values.add(value);
        this.params.put(this.encodeNames ? UrlQueryStringBuilder.urlEncode(name) : name, values);
        return this;
    }

    public UrlQueryStringBuilder set(String name, String value) {
        this.setSafeValue(name, UrlQueryStringBuilder.urlEncode(value));
        return this;
    }

    public UrlQueryStringBuilder setIfNotNull(String name, String value) {
        if (value != null) {
            this.setSafeValue(name, UrlQueryStringBuilder.urlEncode(value));
        }
        return this;
    }

    public UrlQueryStringBuilder set(String name, int value) {
        return this.setSafeValue(name, String.valueOf(value));
    }

    public UrlQueryStringBuilder set(String name, long value) {
        return this.setSafeValue(name, String.valueOf(value));
    }

    public UrlQueryStringBuilder set(String name, boolean value) {
        return this.setSafeValue(name, String.valueOf(value));
    }

    private UrlQueryStringBuilder addSafeValue(String name, String value) {
        this.params.computeIfAbsent(this.encodeNames ? UrlQueryStringBuilder.urlEncode(name) : name, k -> new ArrayList()).add(value);
        return this;
    }

    public UrlQueryStringBuilder add(String name, String value) {
        return this.addSafeValue(name, UrlQueryStringBuilder.urlEncode(value));
    }

    public UrlQueryStringBuilder addIfNotNull(String name, String value) {
        if (value != null) {
            this.addSafeValue(name, UrlQueryStringBuilder.urlEncode(value));
        }
        return this;
    }

    public UrlQueryStringBuilder add(String name, int value) {
        return this.addSafeValue(name, String.valueOf(value));
    }

    public UrlQueryStringBuilder add(String name, long value) {
        return this.addSafeValue(name, String.valueOf(value));
    }

    public UrlQueryStringBuilder add(String name, boolean value) {
        return this.addSafeValue(name, String.valueOf(value));
    }

    public String build() {
        StringBuilder sb = new StringBuilder();
        this.params.forEach((name, values) -> {
            for (String value : values) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append((String)name).append("=").append(value);
            }
        });
        return sb.toString();
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.name()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException inconceivable) {
            throw new AssertionError("UTF-8 not supported", inconceivable);
        }
    }

    public String toString() {
        return this.build();
    }
}

