/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.encryption.databind.jackson;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.encryption.CryptoManager;
import com.couchbase.client.java.encryption.annotation.Encrypted;
import com.couchbase.client.java.encryption.databind.jackson.EncryptedFieldSerializer;
import com.couchbase.client.java.encryption.databind.jackson.EncryptionModule;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Stability.Internal
public class EncryptedFieldSerializationModifier
extends BeanSerializerModifier {
    private final CryptoManager cryptoManager;

    public EncryptedFieldSerializationModifier(CryptoManager cryptoManager) {
        this.cryptoManager = Objects.requireNonNull(cryptoManager);
    }

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        ArrayList<BeanPropertyWriter> result = new ArrayList<BeanPropertyWriter>();
        for (BeanPropertyWriter writer : beanProperties) {
            Encrypted annotation = EncryptionModule.findAnnotation((BeanProperty)writer, Encrypted.class);
            result.add((BeanPropertyWriter)(annotation == null ? writer : new EncryptedBeanPropertyWriter(writer, annotation)));
        }
        return result;
    }

    private class EncryptedBeanPropertyWriter
    extends BeanPropertyWriter {
        EncryptedBeanPropertyWriter(BeanPropertyWriter original, Encrypted annotation) {
            super(original, new SerializedString(EncryptedFieldSerializationModifier.this.cryptoManager.mangle(original.getName())));
            EncryptedFieldSerializer newSerializer = new EncryptedFieldSerializer(EncryptedFieldSerializationModifier.this.cryptoManager, annotation, (JsonSerializer<Object>)original.getSerializer());
            this._serializer = newSerializer;
            this._nullSerializer = newSerializer;
        }
    }
}

