/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.kv.CommonDurabilityOptions;
import com.couchbase.client.java.kv.Expiry;
import java.time.Duration;
import java.time.Instant;

public class UpsertOptions
extends CommonDurabilityOptions<UpsertOptions> {
    private Expiry expiry = Expiry.none();
    private boolean preserveExpiry;
    private Transcoder transcoder;

    private UpsertOptions() {
    }

    public static UpsertOptions upsertOptions() {
        return new UpsertOptions();
    }

    public UpsertOptions expiry(Duration expiry) {
        this.expiry = Expiry.relative(expiry);
        return this;
    }

    public UpsertOptions expiry(Instant expiry) {
        this.expiry = Expiry.absolute(expiry);
        return this;
    }

    @Stability.Uncommitted
    public UpsertOptions preserveExpiry(boolean preserveExpiry) {
        this.preserveExpiry = preserveExpiry;
        return this;
    }

    public UpsertOptions transcoder(Transcoder transcoder) {
        this.transcoder = (Transcoder)Validators.notNull((Object)transcoder, (String)"Transcoder");
        return this;
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    public class Built
    extends CommonDurabilityOptions.BuiltCommonDurabilityOptions {
        Built() {
            super(UpsertOptions.this);
        }

        public Expiry expiry() {
            return UpsertOptions.this.expiry;
        }

        public boolean preserveExpiry() {
            return UpsertOptions.this.preserveExpiry;
        }

        public Transcoder transcoder() {
            return UpsertOptions.this.transcoder;
        }
    }
}

