/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.error.IndexExistsException;
import com.couchbase.client.core.error.IndexNotFoundException;
import com.couchbase.client.core.error.IndexesNotReadyException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.error.QueryException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.retry.reactor.Retry;
import com.couchbase.client.core.retry.reactor.RetryExhaustedException;
import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.manager.query.BuildQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreatePrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreateQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropPrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropQueryIndexOptions;
import com.couchbase.client.java.manager.query.GetAllQueryIndexesOptions;
import com.couchbase.client.java.manager.query.QueryIndex;
import com.couchbase.client.java.manager.query.WatchQueryIndexesOptions;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class AsyncQueryIndexManager {
    private final AsyncCluster cluster;
    private static final Map<Predicate<QueryException>, Function<QueryException, ? extends QueryException>> errorMessageMap = new LinkedHashMap<Predicate<QueryException>, Function<QueryException, ? extends QueryException>>();

    public AsyncQueryIndexManager(AsyncCluster cluster) {
        this.cluster = Objects.requireNonNull(cluster);
    }

    public CompletableFuture<Void> createIndex(String bucketName, String indexName, Collection<String> fields) {
        return this.createIndex(bucketName, indexName, fields, CreateQueryIndexOptions.createQueryIndexOptions());
    }

    public CompletableFuture<Void> createIndex(String bucketName, String indexName, Collection<String> fields, CreateQueryIndexOptions options) {
        CreateQueryIndexOptions.Built builtOpts = options.build();
        String statement = "CREATE INDEX " + AsyncQueryIndexManager.quote(indexName) + " ON " + AsyncQueryIndexManager.quote(bucketName) + AsyncQueryIndexManager.formatIndexFields(fields);
        return ((CompletableFuture)this.exec(QueryType.WRITE, statement, builtOpts.with(), builtOpts, "manager_query_create_index", bucketName).exceptionally(t -> {
            if (builtOpts.ignoreIfExists() && CbThrowables.hasCause((Throwable)t, IndexExistsException.class)) {
                return null;
            }
            CbThrowables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException((Throwable)t);
        })).thenApply(result -> null);
    }

    public CompletableFuture<Void> createPrimaryIndex(String bucketName) {
        return this.createPrimaryIndex(bucketName, CreatePrimaryQueryIndexOptions.createPrimaryQueryIndexOptions());
    }

    public CompletableFuture<Void> createPrimaryIndex(String bucketName, CreatePrimaryQueryIndexOptions options) {
        CreatePrimaryQueryIndexOptions.Built builtOpts = options.build();
        String indexName = builtOpts.indexName().orElse(null);
        String statement = "CREATE PRIMARY INDEX ";
        if (indexName != null) {
            statement = statement + AsyncQueryIndexManager.quote(indexName) + " ";
        }
        statement = statement + "ON " + AsyncQueryIndexManager.quote(bucketName);
        return ((CompletableFuture)this.exec(QueryType.WRITE, statement, builtOpts.with(), builtOpts, "manager_query_create_primary_index", bucketName).exceptionally(t -> {
            if (builtOpts.ignoreIfExists() && CbThrowables.hasCause((Throwable)t, IndexExistsException.class)) {
                return null;
            }
            CbThrowables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException((Throwable)t);
        })).thenApply(result -> null);
    }

    private static String formatIndexFields(Collection<String> fields) {
        return "(" + String.join((CharSequence)",", fields) + ")";
    }

    public CompletableFuture<List<QueryIndex>> getAllIndexes(String bucketName) {
        return this.getAllIndexes(bucketName, GetAllQueryIndexesOptions.getAllQueryIndexesOptions());
    }

    public CompletableFuture<List<QueryIndex>> getAllIndexes(String bucketName, GetAllQueryIndexesOptions options) {
        Objects.requireNonNull(bucketName);
        GetAllQueryIndexesOptions.Built builtOpts = options.build();
        String statement = "SELECT idx.* FROM system:indexes AS idx WHERE keyspace_id = \"" + bucketName + "\" AND `using` = \"gsi\" ORDER BY is_primary DESC, name ASC";
        return this.exec(QueryType.READ_ONLY, statement, builtOpts, "manager_query_get_all_indexes", bucketName).thenApply(result -> result.rowsAsObject().stream().map(QueryIndex::new).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> dropPrimaryIndex(String bucketName) {
        return this.dropPrimaryIndex(bucketName, DropPrimaryQueryIndexOptions.dropPrimaryQueryIndexOptions());
    }

    public CompletableFuture<Void> dropPrimaryIndex(String bucketName, DropPrimaryQueryIndexOptions options) {
        Objects.requireNonNull(bucketName);
        DropPrimaryQueryIndexOptions.Built builtOpts = options.build();
        String statement = "DROP PRIMARY INDEX ON " + AsyncQueryIndexManager.quote(bucketName);
        return ((CompletableFuture)this.exec(QueryType.WRITE, statement, builtOpts, "manager_query_drop_primary_index", bucketName).exceptionally(t -> {
            if (builtOpts.ignoreIfNotExists() && CbThrowables.hasCause((Throwable)t, IndexNotFoundException.class)) {
                return null;
            }
            CbThrowables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException((Throwable)t);
        })).thenApply(result -> null);
    }

    public CompletableFuture<Void> dropIndex(String bucketName, String indexName) {
        return this.dropIndex(bucketName, indexName, DropQueryIndexOptions.dropQueryIndexOptions());
    }

    public CompletableFuture<Void> dropIndex(String bucketName, String indexName, DropQueryIndexOptions options) {
        Objects.requireNonNull(bucketName);
        DropQueryIndexOptions.Built builtOpts = options.build();
        String statement = "DROP INDEX " + AsyncQueryIndexManager.quote(bucketName, indexName);
        return ((CompletableFuture)this.exec(QueryType.WRITE, statement, builtOpts, "manager_query_drop_index", bucketName).exceptionally(t -> {
            if (builtOpts.ignoreIfNotExists() && CbThrowables.hasCause((Throwable)t, IndexNotFoundException.class)) {
                return null;
            }
            CbThrowables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException((Throwable)t);
        })).thenApply(result -> null);
    }

    public CompletableFuture<Void> buildDeferredIndexes(String bucketName) {
        return this.buildDeferredIndexes(bucketName, BuildQueryIndexOptions.buildDeferredQueryIndexesOptions());
    }

    private static GetAllQueryIndexesOptions toGetAllIndexesOptions(CommonOptions.BuiltCommonOptions opts) {
        GetAllQueryIndexesOptions result = GetAllQueryIndexesOptions.getAllQueryIndexesOptions();
        opts.retryStrategy().ifPresent(result::retryStrategy);
        opts.timeout().ifPresent(result::timeout);
        result.clientContext(opts.clientContext());
        return result;
    }

    public CompletableFuture<Void> buildDeferredIndexes(String bucketName, BuildQueryIndexOptions options) {
        Objects.requireNonNull(bucketName);
        BuildQueryIndexOptions.Built builtOpts = options.build();
        return ((CompletableFuture)this.getAllIndexes(bucketName, AsyncQueryIndexManager.toGetAllIndexesOptions(builtOpts)).thenCompose(allIndexes -> {
            List deferredIndexNames = allIndexes.stream().filter(idx -> "deferred".equals(idx.state())).map(QueryIndex::name).collect(Collectors.toList());
            if (deferredIndexNames.isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            String statement = "BUILD INDEX ON " + AsyncQueryIndexManager.quote(bucketName) + "(" + deferredIndexNames.stream().map(AsyncQueryIndexManager::quote).collect(Collectors.joining(",")) + ")";
            return this.exec(QueryType.WRITE, statement, builtOpts, "manager_query_build_deferred_indexes", bucketName);
        })).thenApply(result -> null);
    }

    public CompletableFuture<Void> watchIndexes(String bucketName, Collection<String> indexNames, Duration timeout) {
        return this.watchIndexes(bucketName, indexNames, timeout, WatchQueryIndexesOptions.watchQueryIndexesOptions());
    }

    public CompletableFuture<Void> watchIndexes(String bucketName, Collection<String> indexNames, Duration timeout, WatchQueryIndexesOptions options) {
        Objects.requireNonNull(timeout);
        HashSet<String> indexNameSet = new HashSet<String>(indexNames);
        WatchQueryIndexesOptions.Built builtOpts = options.build();
        RequestSpan parent = this.cluster.environment().requestTracer().requestSpan("manager_query_watch_indexes", null);
        parent.attribute("db.system", "couchbase");
        return Mono.fromFuture(() -> this.failIfIndexesOffline(bucketName, indexNameSet, builtOpts.watchPrimary(), parent)).retryWhen(Retry.onlyIf(ctx -> CbThrowables.hasCause((Throwable)ctx.exception(), IndexesNotReadyException.class)).exponentialBackoff(Duration.ofMillis(50L), Duration.ofSeconds(1L)).timeout(timeout).toReactorRetry()).onErrorMap(t -> t instanceof RetryExhaustedException ? AsyncQueryIndexManager.toWatchTimeoutException(t, timeout) : t).toFuture().whenComplete((r, t) -> parent.end());
    }

    private static TimeoutException toWatchTimeoutException(Throwable t, Duration timeout) {
        StringBuilder msg = new StringBuilder("A requested index is still not ready after " + timeout + ".");
        CbThrowables.findCause((Throwable)t, IndexesNotReadyException.class).ifPresent(cause -> msg.append(" Unready index name -> state: ").append(RedactableArgument.redactMeta((Object)cause.indexNameToState())));
        return new TimeoutException(msg.toString());
    }

    private CompletableFuture<Void> failIfIndexesOffline(String bucketName, Set<String> indexNames, boolean includePrimary, RequestSpan parentSpan) throws IndexesNotReadyException, IndexNotFoundException {
        Objects.requireNonNull(bucketName);
        Objects.requireNonNull(indexNames);
        return this.getAllIndexes(bucketName, (GetAllQueryIndexesOptions)GetAllQueryIndexesOptions.getAllQueryIndexesOptions().parentSpan(parentSpan)).thenApply(allIndexes -> {
            List matchingIndexes = allIndexes.stream().filter(idx -> indexNames.contains(idx.name()) || includePrimary && idx.primary()).collect(Collectors.toList());
            boolean primaryIndexPresent = matchingIndexes.stream().anyMatch(QueryIndex::primary);
            if (includePrimary && !primaryIndexPresent) {
                throw new IndexNotFoundException("#primary");
            }
            Set matchingIndexNames = matchingIndexes.stream().map(QueryIndex::name).collect(Collectors.toSet());
            Set missingIndexNames = AsyncQueryIndexManager.difference(indexNames, matchingIndexNames);
            if (!missingIndexNames.isEmpty()) {
                throw new IndexNotFoundException(missingIndexNames.toString());
            }
            Map<String, String> offlineIndexNameToState = matchingIndexes.stream().filter(idx -> !"online".equals(idx.state())).collect(Collectors.toMap(QueryIndex::name, QueryIndex::state));
            if (!offlineIndexNameToState.isEmpty()) {
                throw new IndexesNotReadyException(offlineIndexNameToState);
            }
            return null;
        });
    }

    private static <T> Set<T> difference(Set<T> lhs, Set<T> rhs) {
        HashSet<T> result = new HashSet<T>(lhs);
        result.removeAll(rhs);
        return result;
    }

    private CompletableFuture<QueryResult> exec(QueryType queryType, CharSequence statement, Map<String, Object> with, CommonOptions.BuiltCommonOptions options, String spanName, String bucketName) {
        return with.isEmpty() ? this.exec(queryType, statement, options, spanName, bucketName) : this.exec(queryType, statement + " WITH " + Mapper.encodeAsString(with), options, spanName, bucketName);
    }

    private CompletableFuture<QueryResult> exec(QueryType queryType, CharSequence statement, CommonOptions.BuiltCommonOptions options, String spanName, String bucketName) {
        QueryOptions queryOpts = AsyncQueryIndexManager.toQueryOptions(options).readonly(Objects.requireNonNull(queryType) == QueryType.READ_ONLY);
        RequestSpan parent = this.cluster.environment().requestTracer().requestSpan(spanName, (RequestSpan)options.parentSpan().orElse(null));
        parent.attribute("db.system", "couchbase");
        if (bucketName != null) {
            parent.attribute("db.name", bucketName);
        }
        queryOpts.parentSpan(parent);
        return ((CompletableFuture)this.cluster.query(statement.toString(), queryOpts).exceptionally(t -> {
            throw this.translateException((Throwable)t);
        })).whenComplete((r, t) -> parent.end());
    }

    private static QueryOptions toQueryOptions(CommonOptions.BuiltCommonOptions options) {
        QueryOptions result = QueryOptions.queryOptions();
        options.timeout().ifPresent(result::timeout);
        options.retryStrategy().ifPresent(result::retryStrategy);
        result.clientContext(options.clientContext());
        return result;
    }

    private static Predicate<QueryException> code(int code) {
        return e -> e.code() == code;
    }

    private static Predicate<QueryException> message(String substringRegex) {
        String CASE_INSENSITIVE = "(?i)";
        return e -> e.msg().matches("(?i).*\\b" + substringRegex + "\\b.*");
    }

    private RuntimeException translateException(Throwable t) {
        if (t instanceof QueryException) {
            QueryException e = (QueryException)t;
            for (Map.Entry<Predicate<QueryException>, Function<QueryException, ? extends QueryException>> entry : errorMessageMap.entrySet()) {
                if (!entry.getKey().test(e)) continue;
                return (RuntimeException)entry.getValue().apply(e);
            }
        }
        return t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
    }

    private static String quote(String s) {
        if (s.contains("`")) {
            throw InvalidArgumentException.fromMessage((String)("Value [" + RedactableArgument.redactMeta((Object)s) + "] may not contain backticks."));
        }
        return "`" + s + "`";
    }

    private static String quote(String ... components) {
        return Arrays.stream(components).map(AsyncQueryIndexManager::quote).collect(Collectors.joining("."));
    }

    static enum QueryType {
        READ_ONLY,
        WRITE;

    }
}

