/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.metrics.opentelemetry;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Counter;
import com.couchbase.client.core.cnc.Meter;
import com.couchbase.client.core.cnc.ValueRecorder;
import com.couchbase.client.core.cnc.metrics.NameAndTags;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.error.MeterException;
import com.couchbase.client.metrics.opentelemetry.OpenTelemetryCounter;
import com.couchbase.client.metrics.opentelemetry.OpenTelemetryValueRecorder;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.MeterProvider;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

@Stability.Volatile
public class OpenTelemetryMeter
implements Meter {
    public static final String INSTRUMENTATION_NAME = "com.couchbase.client.jvm";
    private static final Map<String, Attributes> MANIFEST_INFOS = new ConcurrentHashMap<String, Attributes>();
    private final io.opentelemetry.api.metrics.Meter otMeter;
    private final Map<NameAndTags, OpenTelemetryCounter> counters = new ConcurrentHashMap<NameAndTags, OpenTelemetryCounter>();
    private final Map<NameAndTags, OpenTelemetryValueRecorder> valueRecorders = new ConcurrentHashMap<NameAndTags, OpenTelemetryValueRecorder>();

    @Stability.Volatile
    public static OpenTelemetryMeter wrap(MeterProvider meterProvider) {
        return new OpenTelemetryMeter(meterProvider);
    }

    private OpenTelemetryMeter(MeterProvider meterProvider) {
        String version = null;
        try {
            version = MANIFEST_INFOS.get("couchbase-java-metrics-opentelemetry").getValue("Impl-Version");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.otMeter = version != null ? meterProvider.meterBuilder(INSTRUMENTATION_NAME).setInstrumentationVersion(version).build() : meterProvider.get(INSTRUMENTATION_NAME);
    }

    public Counter counter(String name, Map<String, String> tags) {
        try {
            return this.counters.computeIfAbsent(new NameAndTags(name, tags), key -> {
                LongCounter counter = this.otMeter.counterBuilder(name).build();
                AttributesBuilder builder = io.opentelemetry.api.common.Attributes.builder();
                for (Map.Entry tag : tags.entrySet()) {
                    builder.put((String)tag.getKey(), (String)tag.getValue());
                }
                return new OpenTelemetryCounter(counter.bind(builder.build()));
            });
        }
        catch (Exception ex) {
            throw new MeterException("Failed to create/access Counter", (Throwable)ex);
        }
    }

    public ValueRecorder valueRecorder(String name, Map<String, String> tags) {
        try {
            return this.valueRecorders.computeIfAbsent(new NameAndTags(name, tags), key -> {
                DoubleHistogram vc = this.otMeter.histogramBuilder(name).build();
                AttributesBuilder builder = io.opentelemetry.api.common.Attributes.builder();
                for (Map.Entry tag : tags.entrySet()) {
                    builder.put((String)tag.getKey(), (String)tag.getValue());
                }
                return new OpenTelemetryValueRecorder(vc.bind(builder.build()));
            });
        }
        catch (Exception ex) {
            throw new MeterException("Failed to create/access ValueRecorder", (Throwable)ex);
        }
    }

    static {
        try {
            Enumeration<URL> resources = CoreEnvironment.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                Manifest manifest;
                URL manifestUrl = resources.nextElement();
                if (manifestUrl == null || (manifest = new Manifest(manifestUrl.openStream())).getEntries() == null) continue;
                for (Map.Entry<String, Attributes> entry : manifest.getEntries().entrySet()) {
                    if (!entry.getKey().startsWith("couchbase-")) continue;
                    MANIFEST_INFOS.put(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

