/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc;

import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import java.time.Duration;

public abstract class AbstractEvent
implements Event {
    private final Event.Severity severity;
    private final String category;
    private final Duration duration;
    private final Context context;
    private final long createdAt;

    protected AbstractEvent(Event.Severity severity, Event.Category category, Duration duration, Context context) {
        this(severity, category.path(), duration, context);
    }

    protected AbstractEvent(Event.Severity severity, String category, Duration duration, Context context) {
        this.severity = severity;
        this.category = category;
        this.duration = duration;
        this.context = context;
        this.createdAt = System.nanoTime();
    }

    @Override
    public Event.Severity severity() {
        return this.severity;
    }

    @Override
    public String category() {
        return this.category;
    }

    @Override
    public Duration duration() {
        return this.duration;
    }

    @Override
    public Context context() {
        return this.context;
    }

    @Override
    public long createdAt() {
        return this.createdAt;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{severity=" + (Object)((Object)this.severity) + ", category=" + this.category + ", duration=" + this.duration + ", createdAt=" + this.createdAt + ", description=" + this.description() + ", context=" + this.context.exportAsString(Context.ExportFormat.STRING) + ", cause=" + this.cause() + '}';
    }
}

