/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.config.AlternateAddress;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.service.ServiceType;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NodeInfo {
    private final String hostname;
    private final Map<ServiceType, Integer> directServices;
    private final Map<ServiceType, Integer> sslServices;
    private final Map<String, AlternateAddress> alternateAddresses;
    private final NodeIdentifier nodeIdentifier;
    private int configPort;

    @JsonCreator
    public NodeInfo(@JsonProperty(value="couchApiBase") String viewUri, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="ports") Map<String, Integer> ports, @JsonProperty(value="alternateAddresses") Map<String, AlternateAddress> alternateAddresses) {
        if (hostname == null) {
            throw InvalidArgumentException.fromMessage("NodeInfo hostname cannot be null");
        }
        this.alternateAddresses = alternateAddresses == null ? Collections.emptyMap() : alternateAddresses;
        try {
            this.hostname = this.trimPort(hostname);
        }
        catch (Exception e) {
            throw new CouchbaseException("Could not analyze hostname from config.", e);
        }
        this.directServices = this.parseDirectServices(viewUri, ports);
        this.sslServices = new HashMap<ServiceType, Integer>();
        this.nodeIdentifier = new NodeIdentifier(this.hostname, this.directServices.get((Object)ServiceType.MANAGER));
    }

    public NodeInfo(String hostname, Map<ServiceType, Integer> direct, Map<ServiceType, Integer> ssl, Map<String, AlternateAddress> alternateAddresses) {
        if (hostname == null) {
            throw InvalidArgumentException.fromMessage("NodeInfo hostname cannot be null");
        }
        this.hostname = hostname;
        this.directServices = direct;
        this.sslServices = ssl;
        this.alternateAddresses = alternateAddresses == null ? Collections.emptyMap() : alternateAddresses;
        this.nodeIdentifier = new NodeIdentifier(this.hostname, this.directServices.get((Object)ServiceType.MANAGER));
    }

    public String hostname() {
        return this.hostname;
    }

    public NodeIdentifier identifier() {
        return this.nodeIdentifier;
    }

    public Map<ServiceType, Integer> services() {
        return this.directServices;
    }

    public Map<ServiceType, Integer> sslServices() {
        return this.sslServices;
    }

    public Map<String, AlternateAddress> alternateAddresses() {
        return this.alternateAddresses;
    }

    private Map<ServiceType, Integer> parseDirectServices(String viewUri, Map<String, Integer> input) {
        HashMap<ServiceType, Integer> services = new HashMap<ServiceType, Integer>();
        for (Map.Entry<String, Integer> entry : input.entrySet()) {
            String type = entry.getKey();
            Integer port = entry.getValue();
            if (!type.equals("direct")) continue;
            services.put(ServiceType.KV, port);
        }
        services.put(ServiceType.MANAGER, this.configPort);
        if (viewUri != null) {
            services.put(ServiceType.VIEWS, URI.create(viewUri).getPort());
        }
        return services;
    }

    private String trimPort(String hostname) {
        String[] parts = hostname.split(":");
        this.configPort = Integer.parseInt(parts[parts.length - 1]);
        if (parts.length > 2) {
            String assembledHost = "";
            for (int i = 0; i < parts.length - 1; ++i) {
                assembledHost = assembledHost + parts[i];
                if (parts[i].endsWith("]")) break;
                assembledHost = assembledHost + ":";
            }
            if (assembledHost.startsWith("[") && assembledHost.endsWith("]")) {
                return assembledHost.substring(1, assembledHost.length() - 1);
            }
            if (assembledHost.endsWith(":")) {
                assembledHost = assembledHost.substring(0, assembledHost.length() - 1);
            }
            return assembledHost;
        }
        return parts[0];
    }

    public String toString() {
        return "NodeInfo{host=" + this.hostname + ", ports=" + this.directServices + ", securePorts=" + this.sslServices + ", aa=" + this.alternateAddresses + ", configPort=" + this.configPort + ", nodeIdentifier=" + this.nodeIdentifier + '}';
    }
}

