/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.refresher;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.events.config.BucketConfigRefreshFailedEvent;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ConfigurationProvider;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.ProposedBucketConfigContext;
import com.couchbase.client.core.config.refresher.BucketRefresher;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.kv.CarrierBucketConfigRequest;
import com.couchbase.client.core.retry.FailFastRetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

@Stability.Internal
public class KeyValueBucketRefresher
implements BucketRefresher {
    static final Duration POLLER_INTERVAL = Duration.ofSeconds(1L);
    static final int MAX_PARALLEL_FETCH = 3;
    private final Core core;
    private final Disposable pollRegistration;
    private final ConfigurationProvider provider;
    private final AtomicLong nodeOffset = new AtomicLong(0L);
    private final Map<String, Long> registrations = new ConcurrentHashMap<String, Long>();
    private final Set<String> tainted = ConcurrentHashMap.newKeySet();
    private final long configPollIntervalNanos;
    private final Duration configRequestTimeout;
    private final EventBus eventBus;

    public KeyValueBucketRefresher(ConfigurationProvider provider, Core core) {
        this.core = core;
        this.eventBus = core.context().environment().eventBus();
        this.provider = provider;
        this.configPollIntervalNanos = core.context().environment().ioConfig().configPollInterval().toNanos();
        this.configRequestTimeout = KeyValueBucketRefresher.clampConfigRequestTimeout(this.configPollIntervalNanos);
        this.pollRegistration = Flux.interval((Duration)this.pollerInterval(), (Scheduler)core.context().environment().scheduler()).onBackpressureDrop().filter(v -> !this.registrations.isEmpty()).flatMap(ignored -> Flux.fromIterable(this.registrations.keySet()).flatMap(this::maybeUpdateBucket)).subscribe(provider::proposeBucketConfig);
    }

    protected Duration pollerInterval() {
        return POLLER_INTERVAL;
    }

    static Duration clampConfigRequestTimeout(long configPollIntervalNanos) {
        if (configPollIntervalNanos > TimeUnit.SECONDS.toNanos(5L)) {
            return Duration.ofSeconds(5L);
        }
        if (configPollIntervalNanos < TimeUnit.SECONDS.toNanos(1L)) {
            return Duration.ofSeconds(1L);
        }
        return Duration.ofNanos(configPollIntervalNanos);
    }

    private Mono<ProposedBucketConfigContext> maybeUpdateBucket(String name) {
        Long last = this.registrations.get(name);
        boolean overInterval = last != null && System.nanoTime() - last >= this.configPollIntervalNanos;
        boolean allowed = this.tainted.contains(name) || overInterval;
        return allowed ? this.fetchConfigPerNode(name, this.filterEligibleNodes(name)).next().doOnSuccess(ctx -> this.registrations.replace(name, System.nanoTime())) : Mono.empty();
    }

    private Flux<NodeInfo> filterEligibleNodes(String name) {
        return Flux.defer(() -> {
            BucketConfig config = this.provider.config().bucketConfig(name);
            if (config == null) {
                this.eventBus.publish(new BucketConfigRefreshFailedEvent(this.core.context(), BucketConfigRefreshFailedEvent.RefresherType.KV, BucketConfigRefreshFailedEvent.Reason.NO_BUCKET_FOUND, Optional.empty()));
                return Flux.empty();
            }
            ArrayList<NodeInfo> nodes = new ArrayList<NodeInfo>(config.nodes());
            this.shiftNodeList(nodes);
            return Flux.fromIterable(nodes).filter(n -> n.services().containsKey((Object)ServiceType.KV) || n.sslServices().containsKey((Object)ServiceType.KV)).take(3L);
        });
    }

    private Flux<ProposedBucketConfigContext> fetchConfigPerNode(String name, Flux<NodeInfo> nodes) {
        return nodes.flatMap(nodeInfo -> {
            CoreContext ctx = this.core.context();
            CarrierBucketConfigRequest request = new CarrierBucketConfigRequest(this.configRequestTimeout, ctx, new CollectionIdentifier(name, Optional.empty(), Optional.empty()), FailFastRetryStrategy.INSTANCE, nodeInfo.identifier());
            this.core.send(request);
            return Reactor.wrap(request, request.response(), true).filter(response -> {
                if (!response.status().success()) {
                    this.eventBus.publish(new BucketConfigRefreshFailedEvent(this.core.context(), BucketConfigRefreshFailedEvent.RefresherType.KV, BucketConfigRefreshFailedEvent.Reason.INDIVIDUAL_REQUEST_FAILED, Optional.of(response)));
                }
                return response.status().success();
            }).map(response -> new ProposedBucketConfigContext(name, new String(response.content(), StandardCharsets.UTF_8), nodeInfo.hostname())).onErrorResume(t -> {
                this.eventBus.publish(new BucketConfigRefreshFailedEvent(this.core.context(), BucketConfigRefreshFailedEvent.RefresherType.KV, BucketConfigRefreshFailedEvent.Reason.INDIVIDUAL_REQUEST_FAILED, Optional.of(t)));
                return Mono.empty();
            });
        });
    }

    private <T> void shiftNodeList(List<T> nodeList) {
        int shiftBy = (int)(this.nodeOffset.getAndIncrement() % (long)nodeList.size());
        for (int i = 0; i < shiftBy; ++i) {
            T element = nodeList.remove(0);
            nodeList.add(element);
        }
    }

    @Override
    public Mono<Void> register(String name) {
        return Mono.defer(() -> {
            this.registrations.put(name, 0L);
            return Mono.empty();
        });
    }

    @Override
    public Mono<Void> deregister(String name) {
        return Mono.defer(() -> {
            this.registrations.remove(name);
            return Mono.empty();
        });
    }

    @Override
    public void markTainted(String name) {
        this.tainted.add(name);
    }

    @Override
    public void markUntainted(String name) {
        this.tainted.remove(name);
    }

    @Override
    public Mono<Void> shutdown() {
        return Mono.defer(() -> {
            if (!this.pollRegistration.isDisposed()) {
                this.pollRegistration.dispose();
            }
            return Mono.empty();
        });
    }
}

