/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.diagnostics;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.core.diagnostics.ClusterState;
import com.couchbase.client.core.diagnostics.EndpointDiagnostics;
import com.couchbase.client.core.endpoint.EndpointState;
import com.couchbase.client.core.error.EncodingFailureException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.service.ServiceType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class DiagnosticsResult {
    static final int VERSION = 2;
    private final Map<ServiceType, List<EndpointDiagnostics>> endpoints;
    private final String sdk;
    private final String id;
    private final ClusterState clusterState;

    @Stability.Internal
    public DiagnosticsResult(Map<ServiceType, List<EndpointDiagnostics>> endpoints, String sdk, String id) {
        this.id = id == null ? UUID.randomUUID().toString() : id;
        this.endpoints = endpoints;
        this.sdk = sdk;
        this.clusterState = DiagnosticsResult.aggregateClusterState(endpoints.values());
    }

    static ClusterState aggregateClusterState(Collection<List<EndpointDiagnostics>> endpoints) {
        int numConnected = 0;
        int numFound = 0;
        for (List<EndpointDiagnostics> endpoint : endpoints) {
            for (EndpointDiagnostics diagnostics : endpoint) {
                ++numFound;
                if (diagnostics.state() != EndpointState.CONNECTED) continue;
                ++numConnected;
            }
        }
        if (numFound > 0 && numFound == numConnected) {
            return ClusterState.ONLINE;
        }
        if (numConnected > 0) {
            return ClusterState.DEGRADED;
        }
        return ClusterState.OFFLINE;
    }

    public String id() {
        return this.id;
    }

    public int version() {
        return 2;
    }

    public String sdk() {
        return this.sdk;
    }

    public Map<ServiceType, List<EndpointDiagnostics>> endpoints() {
        return this.endpoints;
    }

    public ClusterState state() {
        return this.clusterState;
    }

    public String exportToJson() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap services = new HashMap();
        for (Map.Entry<ServiceType, List<EndpointDiagnostics>> e : this.endpoints.entrySet()) {
            services.put(e.getKey().ident(), e.getValue().stream().map(EndpointDiagnostics::toMap).collect(Collectors.toList()));
        }
        result.put("version", 2);
        result.put("services", services);
        result.put("sdk", this.sdk);
        result.put("id", this.id);
        result.put("state", this.clusterState.toString().toLowerCase());
        try {
            return Mapper.writer().writeValueAsString(result);
        }
        catch (JsonProcessingException e) {
            throw new EncodingFailureException("Could not encode report to JSON.", e);
        }
    }

    public String toString() {
        return "DiagnosticsResult{endpoints=" + this.endpoints + ", version=" + 2 + ", sdk='" + this.sdk + '\'' + ", id='" + this.id + '\'' + ", state=" + (Object)((Object)this.clusterState) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagnosticsResult that = (DiagnosticsResult)o;
        return Objects.equals(this.endpoints, that.endpoints) && Objects.equals(this.sdk, that.sdk) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.endpoints, this.sdk, this.id);
    }
}

