/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.http;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;
import java.util.Optional;

@Stability.Internal
public interface CoreCommonOptions {
    public static final CoreCommonOptions DEFAULT = new CoreCommonOptions(){

        @Override
        public Optional<Duration> timeout() {
            return Optional.empty();
        }

        @Override
        public Optional<RetryStrategy> retryStrategy() {
            return Optional.empty();
        }

        @Override
        public Optional<RequestSpan> parentSpan() {
            return Optional.empty();
        }
    };

    public Optional<Duration> timeout();

    public Optional<RetryStrategy> retryStrategy();

    public Optional<RequestSpan> parentSpan();

    public static CoreCommonOptions of(final Duration timeout, final RetryStrategy retryStrategy, final RequestSpan parentSpan) {
        if (timeout == null && retryStrategy == null && parentSpan == null) {
            return DEFAULT;
        }
        return new CoreCommonOptions(){

            @Override
            public Optional<Duration> timeout() {
                return Optional.ofNullable(timeout);
            }

            @Override
            public Optional<RetryStrategy> retryStrategy() {
                return Optional.ofNullable(retryStrategy);
            }

            @Override
            public Optional<RequestSpan> parentSpan() {
                return Optional.ofNullable(parentSpan);
            }
        };
    }

    default public CoreCommonOptions withParentSpan(RequestSpan span) {
        return CoreCommonOptions.of(this.timeout().orElse(null), this.retryStrategy().orElse(null), span);
    }
}

