/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error.context;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.context.ErrorContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Stability.Uncommitted
public class AggregateErrorContext
extends ErrorContext {
    private final List<ErrorContext> innerContexts;

    public AggregateErrorContext(List<ErrorContext> innerContexts) {
        super(null);
        this.innerContexts = innerContexts;
    }

    public List<ErrorContext> contexts() {
        return this.innerContexts;
    }

    @Override
    public void injectExportableParams(Map<String, Object> input) {
        super.injectExportableParams(input);
        if (this.innerContexts != null && !this.innerContexts.isEmpty()) {
            ArrayList<HashMap<String, Object>> inner = new ArrayList<HashMap<String, Object>>();
            for (ErrorContext ctx : this.innerContexts) {
                HashMap<String, Object> ctxInner = new HashMap<String, Object>();
                ctx.injectExportableParams(ctxInner);
                inner.add(ctxInner);
            }
            input.put("aggregateErrors", inner);
        }
    }
}

