/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.java.AsyncBinaryCollection;
import com.couchbase.client.java.AsyncUtils;
import com.couchbase.client.java.kv.AppendOptions;
import com.couchbase.client.java.kv.CounterResult;
import com.couchbase.client.java.kv.DecrementOptions;
import com.couchbase.client.java.kv.IncrementOptions;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.PrependOptions;

public class BinaryCollection {
    private final AsyncBinaryCollection async;

    BinaryCollection(AsyncBinaryCollection asyncBinaryCollection) {
        this.async = asyncBinaryCollection;
    }

    public MutationResult append(String id, byte[] content) {
        return AsyncUtils.block(this.async.append(id, content));
    }

    public MutationResult append(String id, byte[] content, AppendOptions options) {
        return AsyncUtils.block(this.async.append(id, content, options));
    }

    public MutationResult prepend(String id, byte[] content) {
        return AsyncUtils.block(this.async.prepend(id, content));
    }

    public MutationResult prepend(String id, byte[] content, PrependOptions options) {
        return AsyncUtils.block(this.async.prepend(id, content, options));
    }

    public CounterResult increment(String id) {
        return AsyncUtils.block(this.async.increment(id));
    }

    public CounterResult increment(String id, IncrementOptions options) {
        return AsyncUtils.block(this.async.increment(id, options));
    }

    public CounterResult decrement(String id) {
        return AsyncUtils.block(this.async.decrement(id));
    }

    public CounterResult decrement(String id, DecrementOptions options) {
        return AsyncUtils.block(this.async.decrement(id, options));
    }
}

