/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.AsyncCollection;
import com.couchbase.client.java.AsyncUtils;
import com.couchbase.client.java.BinaryCollection;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.datastructures.CouchbaseArrayList;
import com.couchbase.client.java.datastructures.CouchbaseArraySet;
import com.couchbase.client.java.datastructures.CouchbaseMap;
import com.couchbase.client.java.datastructures.CouchbaseQueue;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.kv.ArrayListOptions;
import com.couchbase.client.java.kv.ArraySetOptions;
import com.couchbase.client.java.kv.ExistsOptions;
import com.couchbase.client.java.kv.ExistsResult;
import com.couchbase.client.java.kv.GetAllReplicasOptions;
import com.couchbase.client.java.kv.GetAndLockOptions;
import com.couchbase.client.java.kv.GetAndTouchOptions;
import com.couchbase.client.java.kv.GetAnyReplicaOptions;
import com.couchbase.client.java.kv.GetOptions;
import com.couchbase.client.java.kv.GetReplicaResult;
import com.couchbase.client.java.kv.GetResult;
import com.couchbase.client.java.kv.InsertOptions;
import com.couchbase.client.java.kv.LookupInOptions;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.client.java.kv.MapOptions;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.MutateInResult;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.QueueOptions;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.client.java.kv.ReplaceOptions;
import com.couchbase.client.java.kv.TouchOptions;
import com.couchbase.client.java.kv.UnlockOptions;
import com.couchbase.client.java.kv.UpsertOptions;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;

public class Collection {
    private final AsyncCollection asyncCollection;
    private final ReactiveCollection reactiveCollection;
    private final BinaryCollection binaryCollection;

    Collection(AsyncCollection asyncCollection) {
        this.asyncCollection = asyncCollection;
        this.reactiveCollection = new ReactiveCollection(asyncCollection);
        this.binaryCollection = new BinaryCollection(asyncCollection.binary());
    }

    public AsyncCollection async() {
        return this.asyncCollection;
    }

    public ReactiveCollection reactive() {
        return this.reactiveCollection;
    }

    public String name() {
        return this.asyncCollection.name();
    }

    public String bucketName() {
        return this.asyncCollection.bucketName();
    }

    public String scopeName() {
        return this.asyncCollection.scopeName();
    }

    @Stability.Volatile
    public Core core() {
        return this.asyncCollection.core();
    }

    public ClusterEnvironment environment() {
        return this.asyncCollection.environment();
    }

    public BinaryCollection binary() {
        return this.binaryCollection;
    }

    public GetResult get(String id) {
        return AsyncUtils.block(this.async().get(id));
    }

    public GetResult get(String id, GetOptions options) {
        return AsyncUtils.block(this.async().get(id, options));
    }

    public GetResult getAndLock(String id, Duration lockTime) {
        return AsyncUtils.block(this.async().getAndLock(id, lockTime));
    }

    public GetResult getAndLock(String id, Duration lockTime, GetAndLockOptions options) {
        return AsyncUtils.block(this.async().getAndLock(id, lockTime, options));
    }

    public GetResult getAndTouch(String id, Duration expiry) {
        return AsyncUtils.block(this.async().getAndTouch(id, expiry));
    }

    public GetResult getAndTouch(String id, Duration expiry, GetAndTouchOptions options) {
        return AsyncUtils.block(this.async().getAndTouch(id, expiry, options));
    }

    public Stream<GetReplicaResult> getAllReplicas(String id) {
        return this.getAllReplicas(id, ReactiveCollection.DEFAULT_GET_ALL_REPLICAS_OPTIONS);
    }

    public Stream<GetReplicaResult> getAllReplicas(String id, GetAllReplicasOptions options) {
        return this.reactiveCollection.getAllReplicas(id, options).toStream();
    }

    public GetReplicaResult getAnyReplica(String id) {
        return AsyncUtils.block(this.asyncCollection.getAnyReplica(id));
    }

    public GetReplicaResult getAnyReplica(String id, GetAnyReplicaOptions options) {
        return AsyncUtils.block(this.asyncCollection.getAnyReplica(id, options));
    }

    public ExistsResult exists(String id) {
        return AsyncUtils.block(this.async().exists(id));
    }

    public ExistsResult exists(String id, ExistsOptions options) {
        return AsyncUtils.block(this.async().exists(id, options));
    }

    public MutationResult remove(String id) {
        return AsyncUtils.block(this.async().remove(id));
    }

    public MutationResult remove(String id, RemoveOptions options) {
        return AsyncUtils.block(this.async().remove(id, options));
    }

    public MutationResult insert(String id, Object content) {
        return AsyncUtils.block(this.async().insert(id, content));
    }

    public MutationResult insert(String id, Object content, InsertOptions options) {
        return AsyncUtils.block(this.async().insert(id, content, options));
    }

    public MutationResult upsert(String id, Object content) {
        return AsyncUtils.block(this.async().upsert(id, content));
    }

    public MutationResult upsert(String id, Object content, UpsertOptions options) {
        return AsyncUtils.block(this.async().upsert(id, content, options));
    }

    public MutationResult replace(String id, Object content) {
        return AsyncUtils.block(this.async().replace(id, content));
    }

    public MutationResult replace(String id, Object content, ReplaceOptions options) {
        return AsyncUtils.block(this.async().replace(id, content, options));
    }

    public MutationResult touch(String id, Duration expiry) {
        return AsyncUtils.block(this.async().touch(id, expiry));
    }

    public MutationResult touch(String id, Duration expiry, TouchOptions options) {
        return AsyncUtils.block(this.async().touch(id, expiry, options));
    }

    public void unlock(String id, long cas) {
        AsyncUtils.block(this.async().unlock(id, cas));
    }

    public void unlock(String id, long cas, UnlockOptions options) {
        AsyncUtils.block(this.async().unlock(id, cas, options));
    }

    public LookupInResult lookupIn(String id, List<LookupInSpec> specs) {
        return AsyncUtils.block(this.async().lookupIn(id, specs));
    }

    public LookupInResult lookupIn(String id, List<LookupInSpec> specs, LookupInOptions options) {
        return AsyncUtils.block(this.async().lookupIn(id, specs, options));
    }

    public MutateInResult mutateIn(String id, List<MutateInSpec> specs) {
        return AsyncUtils.block(this.async().mutateIn(id, specs));
    }

    public MutateInResult mutateIn(String id, List<MutateInSpec> specs, MutateInOptions options) {
        return AsyncUtils.block(this.async().mutateIn(id, specs, options));
    }

    public <T> List<T> list(String id, Class<T> entityType) {
        return this.list(id, entityType, ArrayListOptions.arrayListOptions());
    }

    public <T> List<T> list(String id, Class<T> entityType, ArrayListOptions options) {
        return new CouchbaseArrayList<T>(id, this, entityType, options);
    }

    public <T> Set<T> set(String id, Class<T> entityType) {
        return this.set(id, entityType, ArraySetOptions.arraySetOptions());
    }

    public <T> Set<T> set(String id, Class<T> entityType, ArraySetOptions options) {
        return new CouchbaseArraySet<T>(id, this, entityType, options);
    }

    public <T> Map<String, T> map(String id, Class<T> entityType) {
        return this.map(id, entityType, MapOptions.mapOptions());
    }

    public <T> Map<String, T> map(String id, Class<T> entityType, MapOptions options) {
        return new CouchbaseMap<T>(id, this, entityType, options);
    }

    public <T> Queue<T> queue(String id, Class<T> entityType) {
        return this.queue(id, entityType, QueueOptions.queueOptions());
    }

    public <T> Queue<T> queue(String id, Class<T> entityType, QueueOptions options) {
        return new CouchbaseQueue<T>(id, this, entityType, options);
    }
}

