/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.analytics;

import com.couchbase.client.core.msg.analytics.AnalyticsResponse;
import com.couchbase.client.java.analytics.AnalyticsMetaData;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.json.JsonObject;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveAnalyticsResult {
    private final AnalyticsResponse response;
    private final JsonSerializer serializer;

    ReactiveAnalyticsResult(AnalyticsResponse response, JsonSerializer serializer) {
        this.response = response;
        this.serializer = serializer;
    }

    public Flux<JsonObject> rowsAsObject() {
        return this.rowsAs(JsonObject.class);
    }

    public <T> Flux<T> rowsAs(Class<T> target) {
        return this.response.rows().map(row -> this.serializer.deserialize(target, row.data()));
    }

    public <T> Flux<T> rowsAs(TypeRef<T> target) {
        return this.response.rows().map(row -> this.serializer.deserialize(target, row.data()));
    }

    public Mono<AnalyticsMetaData> metaData() {
        return this.response.trailer().map(t -> AnalyticsMetaData.from(this.response.header(), t));
    }
}

