/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.codec;

import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JavaType;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.Module;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.client.core.encryption.CryptoManager;
import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.error.EncodingFailureException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.encryption.databind.jackson.repackaged.RepackagedEncryptionModule;
import com.couchbase.client.java.json.RepackagedJsonValueModule;
import java.nio.charset.StandardCharsets;

public class DefaultJsonSerializer
implements JsonSerializer {
    private final ObjectMapper mapper = new ObjectMapper();

    public static DefaultJsonSerializer create() {
        return DefaultJsonSerializer.create(null);
    }

    public static DefaultJsonSerializer create(CryptoManager cryptoManager) {
        return new DefaultJsonSerializer(cryptoManager);
    }

    private DefaultJsonSerializer(CryptoManager cryptoManager) {
        this.mapper.registerModule((Module)new RepackagedJsonValueModule());
        if (cryptoManager != null) {
            this.mapper.registerModule((Module)new RepackagedEncryptionModule(cryptoManager));
        }
    }

    @Override
    public byte[] serialize(Object input) {
        if (input instanceof byte[]) {
            return (byte[])input;
        }
        try {
            return this.mapper.writeValueAsBytes(input);
        }
        catch (Throwable t) {
            throw new EncodingFailureException("Serializing of content + " + RedactableArgument.redactUser((Object)input) + " to JSON failed.", t);
        }
    }

    @Override
    public <T> T deserialize(Class<T> target, byte[] input) {
        if (target.equals(byte[].class)) {
            return (T)input;
        }
        try {
            return (T)this.mapper.readValue(input, target);
        }
        catch (Throwable e) {
            throw new DecodingFailureException("Deserialization of content into target " + target + " failed; encoded = " + RedactableArgument.redactUser((Object)new String(input, StandardCharsets.UTF_8)), e);
        }
    }

    @Override
    public <T> T deserialize(TypeRef<T> target, byte[] input) {
        try {
            JavaType type = this.mapper.getTypeFactory().constructType(target.type());
            return (T)this.mapper.readValue(input, type);
        }
        catch (Throwable e) {
            throw new DecodingFailureException("Deserialization of content into target " + target + " failed; encoded = " + RedactableArgument.redactUser((Object)new String(input, StandardCharsets.UTF_8)), e);
        }
    }
}

