/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.msg.query.QueryChunkHeader;
import com.couchbase.client.core.msg.query.QueryChunkTrailer;
import com.couchbase.client.java.json.JacksonTransformers;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.query.QueryMetrics;
import com.couchbase.client.java.query.QueryStatus;
import com.couchbase.client.java.query.QueryWarning;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class QueryMetaData {
    private final QueryChunkHeader header;
    private final QueryChunkTrailer trailer;

    @Stability.Internal
    private QueryMetaData(QueryChunkHeader header, QueryChunkTrailer trailer) {
        this.header = header;
        this.trailer = trailer;
    }

    @Stability.Internal
    static QueryMetaData from(QueryChunkHeader header, QueryChunkTrailer trailer) {
        return new QueryMetaData(header, trailer);
    }

    public String requestId() {
        return this.header.requestId();
    }

    public String clientContextId() {
        return this.header.clientContextId().orElse("");
    }

    public QueryStatus status() {
        return QueryStatus.from(this.trailer.status());
    }

    public Optional<JsonObject> signature() {
        return this.header.signature().map(v -> {
            try {
                return (JsonObject)JacksonTransformers.MAPPER.readValue(v, JsonObject.class);
            }
            catch (IOException ex) {
                throw new DecodingFailureException((Throwable)ex);
            }
        });
    }

    public Optional<JsonObject> profile() {
        return this.trailer.profile().map(profile -> {
            try {
                return (JsonObject)JacksonTransformers.MAPPER.readValue(profile, JsonObject.class);
            }
            catch (IOException ex) {
                throw new DecodingFailureException((Throwable)ex);
            }
        });
    }

    public Optional<QueryMetrics> metrics() {
        return this.trailer.metrics().map(QueryMetrics::new);
    }

    public List<QueryWarning> warnings() {
        return this.trailer.warnings().map(warnings -> ErrorCodeAndMessage.fromJsonArray((byte[])warnings).stream().map(QueryWarning::new).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public String toString() {
        return "QueryMetaData{header=" + this.header + ", trailer=" + this.trailer + '}';
    }
}

