/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.TreeNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.error.ViewServiceException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.util.Bytes;
import com.couchbase.client.core.util.Golang;
import com.couchbase.client.java.json.JacksonTransformers;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;

public class QueryMetrics {
    public static final QueryMetrics EMPTY_METRICS = new QueryMetrics();
    private final JsonNode rootNode;

    private QueryMetrics() {
        this(Bytes.EMPTY_BYTE_ARRAY);
    }

    QueryMetrics(byte[] raw) {
        try {
            this.rootNode = JacksonTransformers.MAPPER.readTree(raw);
        }
        catch (IOException e) {
            throw new ViewServiceException("Could not parse analytics metrics!");
        }
    }

    public Duration elapsedTime() {
        return this.decode(String.class, "elapsedTime").map(Golang::parseDuration).orElse(Duration.ZERO);
    }

    public Duration executionTime() {
        return this.decode(String.class, "executionTime").map(Golang::parseDuration).orElse(Duration.ZERO);
    }

    public long sortCount() {
        return this.decode(Long.class, "sortCount").orElse(0L);
    }

    public long resultCount() {
        return this.decode(Long.class, "resultCount").orElse(0L);
    }

    public long resultSize() {
        return this.decode(Long.class, "resultSize").orElse(0L);
    }

    public long mutationCount() {
        return this.decode(Long.class, "mutationCount").orElse(0L);
    }

    public long errorCount() {
        return this.decode(Long.class, "errorCount").orElse(0L);
    }

    public long warningCount() {
        return this.decode(Long.class, "warningCount").orElse(0L);
    }

    private <T> Optional<T> decode(Class<T> target, String path) {
        try {
            JsonNode subNode = this.rootNode.path(path);
            if (subNode == null || subNode.isNull() || subNode.isMissingNode()) {
                return Optional.empty();
            }
            return Optional.ofNullable(JacksonTransformers.MAPPER.treeToValue((TreeNode)subNode, target));
        }
        catch (JsonProcessingException e) {
            throw new DecodingFailureException("Could not decode " + path + " in analytics metrics!");
        }
    }

    public String toString() {
        return "QueryMetrics{raw=" + RedactableArgument.redactUser((Object)Mapper.encodeAsString((Object)this.rootNode)) + '}';
    }
}

