/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.msg.query.QueryChunkHeader;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.msg.query.QueryChunkTrailer;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.query.QueryMetaData;
import java.util.ArrayList;
import java.util.List;

public class QueryResult {
    private final List<QueryChunkRow> rows;
    private final QueryChunkHeader header;
    private final QueryChunkTrailer trailer;
    private final JsonSerializer serializer;

    QueryResult(QueryChunkHeader header, List<QueryChunkRow> rows, QueryChunkTrailer trailer, JsonSerializer serializer) {
        this.rows = rows;
        this.header = header;
        this.trailer = trailer;
        this.serializer = serializer;
    }

    public List<JsonObject> rowsAsObject() {
        return this.rowsAs(JsonObject.class);
    }

    public <T> List<T> rowsAs(Class<T> target) {
        ArrayList<T> converted = new ArrayList<T>(this.rows.size());
        for (QueryChunkRow row : this.rows) {
            converted.add(this.serializer.deserialize(target, row.data()));
        }
        return converted;
    }

    public <T> List<T> rowsAs(TypeRef<T> target) {
        ArrayList<T> converted = new ArrayList<T>(this.rows.size());
        for (QueryChunkRow row : this.rows) {
            converted.add(this.serializer.deserialize(target, row.data()));
        }
        return converted;
    }

    public QueryMetaData metaData() {
        return QueryMetaData.from(this.header, this.trailer);
    }

    public String toString() {
        return "QueryResult{rows=" + this.rows + ", header=" + this.header + ", trailer=" + this.trailer + '}';
    }
}

