/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.util.Coordinate;
import java.util.List;

public class GeoPolygonQuery
extends SearchQuery {
    private final List<Coordinate> coordinates;
    private String field;

    public GeoPolygonQuery(List<Coordinate> coordinates) {
        this.coordinates = Validators.notNullOrEmpty(coordinates, (String)"GeoPolygonQuery Coordinates");
    }

    public GeoPolygonQuery field(String field) {
        this.field = field;
        return this;
    }

    @Override
    public GeoPolygonQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    @Override
    protected void injectParams(JsonObject input) {
        JsonArray points = JsonArray.create();
        for (Coordinate coordinate : this.coordinates) {
            points.add(JsonArray.from(coordinate.lon(), coordinate.lat()));
        }
        input.put("polygon_points", points);
        if (this.field != null) {
            input.put("field", this.field);
        }
    }
}

