/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.loader;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.config.ProposedBucketConfigContext;
import com.couchbase.client.core.config.loader.BucketLoader;
import com.couchbase.client.core.error.ConfigException;
import com.couchbase.client.core.error.SeedNodeOutdatedException;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.service.ServiceState;
import com.couchbase.client.core.service.ServiceType;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class BaseBucketLoader
implements BucketLoader {
    private final Core core;
    private final ServiceType serviceType;

    BaseBucketLoader(Core core, ServiceType serviceType) {
        this.core = core;
        this.serviceType = serviceType;
    }

    protected abstract Mono<byte[]> discoverConfig(NodeIdentifier var1, String var2);

    @Override
    public Mono<ProposedBucketConfigContext> load(NodeIdentifier seed, int port, String bucket, Optional<String> alternateAddress) {
        return this.core.ensureServiceAt(seed, this.serviceType, port, Optional.of(bucket), alternateAddress).then(this.ensureServiceConnected(seed, this.serviceType, Optional.of(bucket))).then(this.discoverConfig(seed, bucket)).map(config -> new String((byte[])config, StandardCharsets.UTF_8)).map(config -> config.replace("$HOST", seed.address())).map(config -> new ProposedBucketConfigContext(bucket, (String)config, seed.address())).onErrorResume(ex -> Mono.error((Throwable)(ex instanceof ConfigException ? ex : new ConfigException("Caught exception while loading config.", (Throwable)ex))));
    }

    private Mono<Void> ensureServiceConnected(NodeIdentifier seed, ServiceType serviceType, Optional<String> bucket) {
        return Flux.defer(() -> {
            Optional<Flux<ServiceState>> states = this.core.serviceState(seed, serviceType, bucket);
            return (Publisher)states.orElseGet(() -> Flux.error((Throwable)new SeedNodeOutdatedException("Seed Node " + seed + " for service " + (Object)((Object)serviceType) + " not present anymore, bailing out.")));
        }).map(ss -> {
            if (ss == ServiceState.DISCONNECTED) {
                throw new ConfigException("Seed Node " + seed + " is disconnected, bailing out.");
            }
            return ss;
        }).takeUntil(state -> state == ServiceState.CONNECTED || state == ServiceState.IDLE).then();
    }

    protected Core core() {
        return this.core;
    }
}

