/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Objects;

@Stability.Volatile
public class BucketExistsException
extends CouchbaseException {
    private final String bucketName;

    BucketExistsException(String bucketName) {
        super("Bucket [" + RedactableArgument.redactMeta(bucketName) + "] already exists.");
        this.bucketName = Objects.requireNonNull(bucketName);
    }

    public static BucketExistsException forBucket(String bucketName) {
        return new BucketExistsException(bucketName);
    }

    public String bucketName() {
        return this.bucketName;
    }
}

