/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error.context;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.kv.SubDocumentOpResponseStatus;
import java.util.Map;

@Stability.Uncommitted
public class SubDocumentErrorContext
extends ErrorContext {
    private final KeyValueErrorContext kvContext;
    private final int index;
    private final String path;
    private final SubDocumentOpResponseStatus status;

    public SubDocumentErrorContext(KeyValueErrorContext kvContext, int index, String path, SubDocumentOpResponseStatus status) {
        super(kvContext.responseStatus());
        this.kvContext = kvContext;
        this.index = index;
        this.path = path;
        this.status = status;
    }

    public int index() {
        return this.index;
    }

    @Override
    public void injectExportableParams(Map<String, Object> input) {
        super.injectExportableParams(input);
        if (this.kvContext != null) {
            this.kvContext.injectExportableParams(input);
        }
        input.put("index", this.index);
        if (this.path != null) {
            input.put("path", RedactableArgument.redactUser(this.path));
        }
        if (this.status != null) {
            input.put("subdocStatus", (Object)this.status);
        }
    }
}

