/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error.transaction;

import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.CoreTransactionGetResult;
import com.couchbase.client.core.transaction.util.DebugUtil;

public class DocumentAlreadyInTransactionException
extends CouchbaseException {
    private final CoreTransactionGetResult doc;

    private DocumentAlreadyInTransactionException(CoreTransactionAttemptContext ctx, CoreTransactionGetResult doc, String msg) {
        super(msg);
        this.doc = doc;
    }

    public static DocumentAlreadyInTransactionException create(CoreTransactionAttemptContext ctx, CoreTransactionGetResult doc) {
        StringBuilder msg = new StringBuilder();
        msg.append("Document ");
        msg.append(DebugUtil.docId(doc));
        msg.append(" is already in a transaction, atr=");
        msg.append(doc.links().atrBucketName().orElse("-"));
        msg.append('/');
        msg.append(doc.links().atrId().orElse("-"));
        msg.append(" attemptId=");
        msg.append(doc.links().stagedAttemptId().orElse("-"));
        return new DocumentAlreadyInTransactionException(ctx, doc, msg.toString());
    }

    public String docId() {
        return this.doc.id();
    }
}

