/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty;

import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.events.io.GenericFailureDetectedEvent;
import com.couchbase.client.core.cnc.events.io.SecureConnectionFailedEvent;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.channel.ChannelInboundHandlerAdapter;
import com.couchbase.client.core.deps.io.netty.handler.codec.DecoderException;
import com.couchbase.client.core.endpoint.BaseEndpoint;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.io.IoContext;
import javax.net.ssl.SSLException;

public class PipelineErrorHandler
extends ChannelInboundHandlerAdapter {
    private final BaseEndpoint endpoint;
    private final EventBus eventBus;
    private final EndpointContext endpointContext;
    private IoContext ioContext;

    public PipelineErrorHandler(BaseEndpoint endpoint) {
        this.endpoint = endpoint;
        this.endpointContext = endpoint.context();
        this.eventBus = this.endpointContext.environment().eventBus();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.assembleIoContext(ctx);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.assembleIoContext(ctx);
        if (cause instanceof DecoderException && cause.getCause() instanceof SSLException) {
            this.eventBus.publish(new SecureConnectionFailedEvent(this.ioContext, (SSLException)cause.getCause()));
        } else {
            this.eventBus.publish(new GenericFailureDetectedEvent(this.ioContext, cause));
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        this.endpoint.notifyChannelInactive();
        ctx.fireChannelActive();
    }

    private void assembleIoContext(ChannelHandlerContext ctx) {
        if (this.ioContext == null) {
            this.ioContext = new IoContext(this.endpointContext, ctx.channel().localAddress(), ctx.channel().remoteAddress(), this.endpointContext.bucket());
        }
    }
}

