/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.events.io.CustomTlsCiphersEnabledEvent;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.handler.ssl.OpenSsl;
import com.couchbase.client.core.deps.io.netty.handler.ssl.SslContextBuilder;
import com.couchbase.client.core.deps.io.netty.handler.ssl.SslHandler;
import com.couchbase.client.core.deps.io.netty.handler.ssl.SslProvider;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.env.SecurityConfig;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.InvalidArgumentException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

@Stability.Internal
public class SslHandlerFactory {
    private static final boolean OPENSSL_AVAILABLE = OpenSsl.isAvailable();

    public static SslHandler get(ByteBufAllocator allocator, SecurityConfig config, EndpointContext endpointContext) throws Exception {
        SslContextBuilder context = SslHandlerFactory.sslContextBuilder(config.nativeTlsEnabled());
        if (config.trustManagerFactory() != null) {
            context.trustManager(config.trustManagerFactory());
        } else if (config.trustCertificates() != null && !config.trustCertificates().isEmpty()) {
            context.trustManager(config.trustCertificates().toArray(new X509Certificate[0]));
        }
        List<String> ciphers = config.ciphers();
        if (ciphers != null && !ciphers.isEmpty()) {
            context.ciphers(ciphers);
            endpointContext.environment().eventBus().publish(new CustomTlsCiphersEnabledEvent(ciphers, endpointContext));
        }
        endpointContext.authenticator().applyTlsProperties(context);
        SslHandler sslHandler = context.build().newHandler(allocator, endpointContext.remoteSocket().host(), endpointContext.remoteSocket().port());
        SSLEngine sslEngine = sslHandler.engine();
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        if (config.hostnameVerificationEnabled()) {
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        }
        sslEngine.setSSLParameters(sslParameters);
        return sslHandler;
    }

    private static SslContextBuilder sslContextBuilder(boolean nativeTlsEnabled) {
        SslProvider provider = OPENSSL_AVAILABLE && nativeTlsEnabled ? SslProvider.OPENSSL : SslProvider.JDK;
        return SslContextBuilder.forClient().sslProvider(provider);
    }

    @Stability.Internal
    public static boolean opensslAvailable() {
        return OPENSSL_AVAILABLE;
    }

    @Stability.Internal
    public static List<String> defaultCiphers(boolean nativeTlsEnabled) {
        if (nativeTlsEnabled && !OPENSSL_AVAILABLE) {
            throw InvalidArgumentException.fromMessage("nativeTlsEnabled, but it is not available on this platform!");
        }
        try {
            SslContextBuilder builder = SslHandlerFactory.sslContextBuilder(nativeTlsEnabled);
            return builder.build().cipherSuites();
        }
        catch (Exception ex) {
            throw new CouchbaseException("Could not get list of default ciphers", ex);
        }
    }
}

