/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty;

import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.events.io.ReadTrafficCapturedEvent;
import com.couchbase.client.core.cnc.events.io.WriteTrafficCapturedEvent;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufUtil;
import com.couchbase.client.core.deps.io.netty.channel.ChannelDuplexHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPromise;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.io.IoContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.UnsignedLEB128;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;

public class TrafficCaptureHandler
extends ChannelDuplexHandler {
    private final EndpointContext endpointContext;
    private final EventBus eventBus;
    private IoContext ioContext;

    public TrafficCaptureHandler(EndpointContext endpointContext) {
        this.endpointContext = endpointContext;
        this.eventBus = endpointContext.environment().eventBus();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.ioContext = new IoContext(this.endpointContext, ctx.channel().localAddress(), ctx.channel().remoteAddress(), this.endpointContext.bucket());
        ctx.fireChannelActive();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof ByteBuf) {
            this.eventBus.publish(new ReadTrafficCapturedEvent(this.ioContext, this.byteBufToString((ByteBuf)msg)));
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof ByteBuf) {
            this.eventBus.publish(new WriteTrafficCapturedEvent(this.ioContext, this.byteBufToString((ByteBuf)msg)));
        }
        ctx.write(msg, promise);
    }

    private String byteBufToString(ByteBuf msg) {
        if (this.endpointContext.serviceType() == ServiceType.KV) {
            return this.memcacheToString(msg);
        }
        return ByteBufUtil.prettyHexDump(msg);
    }

    private String memcacheToString(ByteBuf msg) {
        StringBuilder sb = new StringBuilder(ByteBufUtil.prettyHexDump(msg));
        byte magic = MemcacheProtocol.magic(msg);
        if (MemcacheProtocol.Magic.of(magic) != null) {
            MemcacheProtocol.FlexibleExtras extras;
            sb.append("\n\n");
            sb.append("------ Field ------+ Offset +--- Value ---\n");
            sb.append("Magic              | 0      | 0x").append(String.format("%02X %s\n", magic, TrafficCaptureHandler.emptyIfNull((Object)MemcacheProtocol.Magic.of(magic))));
            byte opcode = MemcacheProtocol.opcode(msg);
            sb.append("Opcode             | 1      | 0x").append(String.format("%02X %s\n", opcode, TrafficCaptureHandler.emptyIfNull((Object)MemcacheProtocol.Opcode.of(opcode))));
            short keyLength = MemcacheProtocol.keyLength(msg);
            if (MemcacheProtocol.isFlexible(msg)) {
                byte flexExtrasLength = MemcacheProtocol.flexExtrasLength(msg);
                sb.append("Flex Extras Length | 2      | 0x").append(String.format("%02X (%d)\n", flexExtrasLength, flexExtrasLength));
                sb.append("Key Length         | 3      | 0x").append(String.format("%02X (%d)\n", keyLength, keyLength));
            } else {
                sb.append("Key Length         | 2-3    | 0x").append(String.format("%04X (%d)\n", keyLength, keyLength));
            }
            byte extrasLength = MemcacheProtocol.extrasLength(msg);
            sb.append("Extras Length      | 4      | 0x").append(String.format("%02X (%d)\n", extrasLength, extrasLength));
            byte datatype = MemcacheProtocol.datatype(msg);
            sb.append("Datatype           | 5      | 0x").append(String.format("%02X %s\n", datatype, TrafficCaptureHandler.emptyIfNull((Object)MemcacheProtocol.Datatype.of(datatype))));
            short status = MemcacheProtocol.status(msg);
            if (MemcacheProtocol.isRequest(msg)) {
                sb.append("VBucket            | 6-7    | 0x").append(String.format("%04X (%d)\n", status, status));
            } else {
                sb.append("Status             | 6-7    | 0x").append(String.format("%04X %s\n", status, TrafficCaptureHandler.emptyIfNull((Object)MemcacheProtocol.Status.of(status))));
            }
            int totalBodyLength = MemcacheProtocol.totalBodyLength(msg);
            sb.append("Total Body Length  | 8-11   | 0x").append(String.format("%08X (%d)\n", totalBodyLength, totalBodyLength));
            int opaque = MemcacheProtocol.opaque(msg);
            sb.append("Opaque             | 12-15  | 0x").append(String.format("%08X\n", opaque));
            long cas = MemcacheProtocol.cas(msg);
            sb.append("CAS                | 16-23  | 0x").append(String.format("%016X\n", cas));
            sb.append("----- Payload -----+--------+-------------\n");
            if (MemcacheProtocol.isFlexible(msg) && (extras = MemcacheProtocol.flexibleExtras(msg)) != null) {
                LinkedHashMap<String, Object> flexExtras = new LinkedHashMap<String, Object>();
                extras.injectExportableParams(flexExtras);
                sb.append(">> Flexible Extras: ").append(Mapper.encodeAsString(flexExtras)).append("\n");
            }
            MemcacheProtocol.key(msg).ifPresent(buf -> {
                int skipped = UnsignedLEB128.skip(buf);
                int keyLen = buf.readableBytes();
                sb.append(">> Key: ").append(buf.toString(skipped, keyLen, StandardCharsets.UTF_8));
                if (skipped > 0) {
                    long leb = UnsignedLEB128.read(buf.slice(0, skipped));
                    sb.append(" (Collection ID: 0x").append(Integer.toHexString((int)leb)).append(")");
                }
                sb.append("\n");
            });
            sb.append("-------------------+--------+-------------\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    private static String emptyIfNull(Object object) {
        if (object == null) {
            return "";
        }
        return "(" + object + ")";
    }
}

