/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv.sasl;

import com.couchbase.client.core.io.netty.kv.sasl.ScramSaslClient;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;

public class ScramSaslClientFactory
implements SaslClientFactory {
    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        if (authorizationId != null) {
            throw new SaslException("AuthorizationId is not supported");
        }
        if (cbh == null) {
            throw new SaslException("Callback handler required");
        }
        Optional<Mode> mode = Mode.strongestOf(mechanisms);
        if (!mode.isPresent()) {
            return null;
        }
        try {
            return new ScramSaslClient(mode.get(), cbh);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException("Selected algorithm not supported.", e);
        }
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return (String[])Stream.of(Mode.values()).map(Mode::mech).toArray(String[]::new);
    }

    static enum Mode {
        SCRAM_SHA512("SCRAM-SHA512"),
        SCRAM_SHA256("SCRAM-SHA256"),
        SCRAM_SHA1("SCRAM-SHA1");

        private final String mech;

        private Mode(String mech) {
            this.mech = mech;
        }

        public String mech() {
            return this.mech;
        }

        static Optional<Mode> from(String mech) {
            if (SCRAM_SHA1.mech().equalsIgnoreCase(mech)) {
                return Optional.of(SCRAM_SHA1);
            }
            if (SCRAM_SHA256.mech().equalsIgnoreCase(mech)) {
                return Optional.of(SCRAM_SHA256);
            }
            if (SCRAM_SHA512.mech().equalsIgnoreCase(mech)) {
                return Optional.of(SCRAM_SHA512);
            }
            return Optional.empty();
        }

        static Optional<Mode> strongestOf(String[] mechs) {
            Set foundModes = Stream.of(mechs).map(Mode::from).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
            if (foundModes.isEmpty()) {
                return Optional.empty();
            }
            if (foundModes.contains((Object)SCRAM_SHA512)) {
                return Optional.of(SCRAM_SHA512);
            }
            if (foundModes.contains((Object)SCRAM_SHA256)) {
                return Optional.of(SCRAM_SHA256);
            }
            return Optional.of(SCRAM_SHA1);
        }
    }
}

