/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.env.CompressionConfig;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.kv.ReplaceResponse;
import com.couchbase.client.core.msg.kv.SyncDurabilityRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;
import java.util.Optional;

public class ReplaceRequest
extends BaseKeyValueRequest<ReplaceResponse>
implements SyncDurabilityRequest {
    private final byte[] content;
    private final long expiration;
    private final boolean preserveExpiry;
    private final int flags;
    private final long cas;
    private final Optional<DurabilityLevel> syncReplicationType;

    public ReplaceRequest(String key, byte[] content, long expiration, boolean preserveExpiry, int flags, Duration timeout, long cas, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, Optional<DurabilityLevel> syncReplicationType, RequestSpan span) {
        super(timeout, ctx, retryStrategy, key, collectionIdentifier, span);
        if (expiration != 0L && preserveExpiry) {
            throw InvalidArgumentException.fromMessage("For replace, must not specify both `expiry` and `preserveExpiry`.");
        }
        this.content = content;
        this.expiration = expiration;
        this.preserveExpiry = preserveExpiry;
        this.flags = flags;
        this.cas = cas;
        this.syncReplicationType = syncReplicationType;
        if (span != null && !CbTracing.isInternalSpan(span)) {
            span.attribute("db.operation", "replace");
            this.applyLevelOnSpan(syncReplicationType, span);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf key = null;
        ByteBuf content = null;
        ByteBuf extras = null;
        ByteBuf flexibleExtras = MemcacheProtocol.mutationFlexibleExtras(this, ctx, alloc, this.syncReplicationType, this.preserveExpiry);
        try {
            key = this.encodedKeyWithCollection(alloc, ctx);
            byte datatype = 0;
            CompressionConfig config = ctx.compressionConfig();
            if (config != null && config.enabled() && this.content.length >= config.minSize()) {
                ByteBuf maybeCompressed = MemcacheProtocol.tryCompression(this.content, config.minRatio());
                if (maybeCompressed != null) {
                    datatype = (byte)(datatype | MemcacheProtocol.Datatype.SNAPPY.datatype());
                    content = maybeCompressed;
                } else {
                    content = Unpooled.wrappedBuffer(this.content);
                }
            } else {
                content = Unpooled.wrappedBuffer(this.content);
            }
            extras = alloc.buffer(8);
            extras.writeInt(this.flags);
            extras.writeInt((int)this.expiration);
            byteBuf = MemcacheProtocol.flexibleRequest(alloc, MemcacheProtocol.Opcode.REPLACE, datatype, this.partition(), opaque, this.cas, flexibleExtras, extras, key, content);
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(key);
            ReferenceCountUtil.release(extras);
            ReferenceCountUtil.release(flexibleExtras);
            ReferenceCountUtil.release(content);
            throw throwable;
        }
        ReferenceCountUtil.release(key);
        ReferenceCountUtil.release(extras);
        ReferenceCountUtil.release(flexibleExtras);
        ReferenceCountUtil.release(content);
        return byteBuf;
    }

    @Override
    public ReplaceResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        ResponseStatus status = MemcacheProtocol.decodeStatus(response);
        return new ReplaceResponse(status, MemcacheProtocol.cas(response), MemcacheProtocol.extractToken(ctx.mutationTokensEnabled(), this.partition(), response, ctx.bucket().get()), MemcacheProtocol.flexibleExtras(response));
    }

    @Override
    public Optional<DurabilityLevel> durabilityLevel() {
        return this.syncReplicationType;
    }

    @Override
    public String name() {
        return "replace";
    }
}

