/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.projections;

import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ContainerNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.kv.SubDocumentField;
import com.couchbase.client.core.msg.kv.SubDocumentOpResponseStatus;
import com.couchbase.client.core.msg.kv.SubdocGetResponse;
import com.couchbase.client.core.projections.JsonPathParser;
import com.couchbase.client.core.projections.PathArray;
import com.couchbase.client.core.projections.PathElement;
import com.couchbase.client.core.projections.PathObjectOrField;
import java.util.List;
import java.util.Map;

public class ProjectionsApplier {
    private static final String MACRO_PREFIX = "$document";

    private ProjectionsApplier() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static byte[] reconstructDocument(SubdocGetResponse subdocGetResponse) {
        ObjectNode result = Mapper.createObjectNode();
        for (SubDocumentField field : subdocGetResponse.values()) {
            if (field == null || field.status() != SubDocumentOpResponseStatus.SUCCESS || field.path().isEmpty() || field.path().startsWith(MACRO_PREFIX)) continue;
            ProjectionsApplier.insert(result, field);
        }
        return Mapper.encodeAsBytes(result);
    }

    public static byte[] reconstructDocument(Map<String, byte[]> pathToValue) {
        ObjectNode result = Mapper.createObjectNode();
        pathToValue.forEach((path, value) -> ProjectionsApplier.insert(result, path, value));
        return Mapper.encodeAsBytes(result);
    }

    private static void insert(ObjectNode document, SubDocumentField field) {
        ProjectionsApplier.insert(document, field.path(), field.value());
    }

    private static void insert(ObjectNode document, String path, byte[] value) {
        List<PathElement> parsedPath = JsonPathParser.parse(path);
        JsonNode content = Mapper.decodeIntoTree(value);
        ProjectionsApplier.insertRecursive(document, parsedPath, content);
    }

    private static void insertRecursive(ContainerNode<?> out, List<PathElement> path, JsonNode content) {
        if (path.isEmpty()) {
            return;
        }
        if (path.size() == 1) {
            PathElement leaf = path.get(0);
            if (leaf instanceof PathArray) {
                PathArray v = (PathArray)leaf;
                ArrayNode toInsert = out.arrayNode().add(content);
                if (out.isObject()) {
                    ((ObjectNode)out).set(v.str(), toInsert);
                } else {
                    ((ArrayNode)out).add(toInsert);
                }
            } else {
                PathObjectOrField v = (PathObjectOrField)leaf;
                if (out.isObject()) {
                    ((ObjectNode)out).set(v.str(), content);
                } else {
                    ObjectNode toInsert = out.objectNode();
                    toInsert.set(v.str(), content);
                    ((ArrayNode)out).add(toInsert);
                }
            }
        } else {
            PathElement next = path.get(0);
            List<PathElement> remaining = path.subList(1, path.size());
            if (next instanceof PathArray) {
                PathArray v = (PathArray)next;
                ArrayNode toInsert = out.arrayNode();
                if (out.isObject()) {
                    ((ObjectNode)out).set(v.str(), toInsert);
                    ProjectionsApplier.insertRecursive(toInsert, remaining, content);
                } else {
                    ((ArrayNode)out).add(toInsert);
                    ProjectionsApplier.insertRecursive(out, remaining, content);
                }
            } else {
                PathObjectOrField v = (PathObjectOrField)next;
                if (out.isObject()) {
                    ObjectNode createIn = (ObjectNode)out.get(v.str());
                    if (createIn == null) {
                        createIn = out.objectNode();
                    }
                    ((ObjectNode)out).set(v.str(), createIn);
                    ProjectionsApplier.insertRecursive(createIn, remaining, content);
                } else {
                    ObjectNode toCreate = out.objectNode();
                    ObjectNode nextToCreate = out.objectNode();
                    toCreate.set(v.str(), nextToCreate);
                    ((ArrayNode)out).add(toCreate);
                    ProjectionsApplier.insertRecursive(nextToCreate, remaining, content);
                }
            }
        }
    }
}

