/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service.strategy;

import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.endpoint.EndpointState;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.service.EndpointSelectionStrategy;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobinSelectionStrategy
implements EndpointSelectionStrategy {
    private final AtomicInteger skip = new AtomicInteger(0);

    @Override
    public <R extends Request<? extends Response>> Endpoint select(R request, List<Endpoint> endpoints) {
        Endpoint endpoint;
        int offset;
        int i;
        int endpointSize = endpoints.size();
        this.skip.set(Math.max(0, this.skip.get() + 1));
        for (i = offset = this.skip.get() % endpointSize; i < endpointSize; ++i) {
            endpoint = endpoints.get(i);
            if (endpoint.state() != EndpointState.CONNECTED || !endpoint.freeToWrite()) continue;
            return endpoint;
        }
        for (i = 0; i < offset; ++i) {
            endpoint = endpoints.get(i);
            if (endpoint.state() != EndpointState.CONNECTED || !endpoint.freeToWrite()) continue;
            return endpoint;
        }
        return null;
    }

    void setSkip(int newValue) {
        this.skip.set(newValue < 0 ? 0 : newValue);
    }

    int currentSkip() {
        return this.skip.get();
    }
}

