/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.transaction.cleanup.CleanerFactory;
import com.couchbase.client.core.transaction.cleanup.ClientRecordFactory;
import com.couchbase.client.core.transaction.config.CoreTransactionOptions;
import com.couchbase.client.core.transaction.config.CoreTransactionsCleanupConfig;
import com.couchbase.client.core.transaction.config.CoreTransactionsConfig;
import com.couchbase.client.core.transaction.support.TransactionAttemptContextFactory;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

@Stability.Internal
public class CoreMergedTransactionConfig {
    private final CoreTransactionsConfig config;
    private final Optional<CoreTransactionOptions> perConfig;

    public CoreMergedTransactionConfig(CoreTransactionsConfig config) {
        this(config, Optional.empty());
    }

    public CoreMergedTransactionConfig(CoreTransactionsConfig config, Optional<CoreTransactionOptions> perConfig) {
        this.config = Objects.requireNonNull(config);
        this.perConfig = Objects.requireNonNull(perConfig);
    }

    public Optional<String> scanConsistency() {
        if (this.perConfig.flatMap(CoreTransactionOptions::scanConsistency).isPresent()) {
            return this.perConfig.flatMap(CoreTransactionOptions::scanConsistency);
        }
        return this.config.scanConsistency();
    }

    public Optional<RequestSpan> parentSpan() {
        return this.perConfig.flatMap(CoreTransactionOptions::parentSpan);
    }

    public Duration expirationTime() {
        return this.perConfig.flatMap(CoreTransactionOptions::timeout).orElse(this.config.transactionExpirationTime());
    }

    public CoreTransactionsCleanupConfig cleanupConfig() {
        return this.config.cleanupConfig();
    }

    public DurabilityLevel durabilityLevel() {
        return this.perConfig.flatMap(CoreTransactionOptions::durabilityLevel).orElse(this.config.durabilityLevel());
    }

    public TransactionAttemptContextFactory attemptContextFactory() {
        return this.perConfig.flatMap(CoreTransactionOptions::attemptContextFactory).orElse(this.config.attemptContextFactory());
    }

    public CleanerFactory cleanerFactory() {
        return this.config.cleanerFactory();
    }

    public ClientRecordFactory clientRecordFactory() {
        return this.config.clientRecordFactory();
    }

    public int numAtrs() {
        return this.config.numAtrs();
    }

    public Optional<CollectionIdentifier> metadataCollection() {
        if (this.perConfig.isPresent() && this.perConfig.get().metadataCollection().isPresent()) {
            return this.perConfig.get().metadataCollection();
        }
        return this.config.metadataCollection();
    }
}

