/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.error.DefaultErrorUtil;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.GetMetaRequest;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.java.kv.ExistsResult;
import java.util.concurrent.CompletableFuture;

public class ExistsAccessor {
    private static ExistsResult CACHED_NOT_FOUND = new ExistsResult(false, 0L);

    public static CompletableFuture<ExistsResult> exists(String key, Core core, GetMetaRequest request) {
        core.send((Request)request);
        return ((CompletableFuture)request.response().thenApply(response -> {
            boolean success = response.status().success();
            boolean deleted = response.deleted();
            if (success && !deleted) {
                return new ExistsResult(true, response.cas());
            }
            if (response.status() == ResponseStatus.NOT_FOUND || success) {
                return CACHED_NOT_FOUND;
            }
            throw DefaultErrorUtil.keyValueStatusToException((KeyValueRequest)request, (Response)response);
        })).whenComplete((t, e) -> request.context().logicallyComplete(e));
    }
}

