/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.kv.MutationState;
import com.couchbase.client.java.kv.ScanSort;
import java.util.Optional;

@Stability.Volatile
public class ScanOptions
extends CommonOptions<ScanOptions> {
    private boolean idsOnly = false;
    private ScanSort sort = ScanSort.NONE;
    private int batchItemLimit = 50;
    private int batchByteLimit = 15000;
    private Optional<MutationState> consistentWith = Optional.empty();
    private Transcoder transcoder;

    public static ScanOptions scanOptions() {
        return new ScanOptions();
    }

    private ScanOptions() {
    }

    public ScanOptions idsOnly(boolean idsOnly) {
        this.idsOnly = idsOnly;
        return this;
    }

    public ScanOptions sort(ScanSort sort) {
        this.sort = (ScanSort)((Object)Validators.notNull((Object)((Object)sort), (String)"ScanSort"));
        return this;
    }

    public ScanOptions transcoder(Transcoder transcoder) {
        this.transcoder = (Transcoder)Validators.notNull((Object)transcoder, (String)"Transcoder");
        return this;
    }

    public ScanOptions consistentWith(MutationState mutationState) {
        this.consistentWith = Optional.ofNullable(mutationState);
        return this;
    }

    public ScanOptions batchByteLimit(int batchByteLimit) {
        if (batchByteLimit < 0) {
            throw InvalidArgumentException.fromMessage((String)"The batchByteLimit must not be smaller than 0");
        }
        this.batchByteLimit = batchByteLimit;
        return this;
    }

    public ScanOptions batchItemLimit(int batchItemLimit) {
        if (batchItemLimit < 0) {
            throw InvalidArgumentException.fromMessage((String)"The batchItemLimit must not be smaller than 0");
        }
        this.batchItemLimit = batchItemLimit;
        return this;
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    @Stability.Internal
    public class Built
    extends CommonOptions.BuiltCommonOptions {
        public Built() {
            super(ScanOptions.this);
        }

        public boolean idsOnly() {
            return ScanOptions.this.idsOnly;
        }

        public ScanSort sort() {
            return ScanOptions.this.sort;
        }

        public Transcoder transcoder() {
            return ScanOptions.this.transcoder;
        }

        public int batchItemLimit() {
            return ScanOptions.this.batchItemLimit;
        }

        public int batchByteLimit() {
            return ScanOptions.this.batchByteLimit;
        }

        public Optional<MutationState> consistentWith() {
            return ScanOptions.this.consistentWith;
        }
    }
}

