/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.DefaultErrorUtil;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.UpsertRequest;
import com.couchbase.client.java.kv.DurabilityUtils;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@Stability.Internal
public enum UpsertAccessor {


    public static CompletableFuture<MutationResult> upsert(Core core, UpsertRequest request, String key, PersistTo persistTo, ReplicateTo replicateTo) {
        core.send((Request)request);
        CompletionStage mutationResult = request.response().thenApply(response -> {
            if (response.status().success()) {
                return new MutationResult(response.cas(), response.mutationToken());
            }
            throw DefaultErrorUtil.keyValueStatusToException((KeyValueRequest)request, (Response)response);
        });
        return DurabilityUtils.wrapWithDurability(mutationResult, key, persistTo, replicateTo, core, request, false);
    }
}

