/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.result;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.search.result.SearchRowLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Stability.Volatile
public class SearchRowLocations {
    private final Map<String, Map<String, List<SearchRowLocation>>> locations = new HashMap<String, Map<String, List<SearchRowLocation>>>();
    private int size;

    private SearchRowLocations add(SearchRowLocation l) {
        Map byTerm = this.locations.computeIfAbsent(l.field(), k -> new HashMap());
        List list = byTerm.computeIfAbsent(l.term(), k -> new ArrayList());
        list.add(l);
        ++this.size;
        return this;
    }

    public List<SearchRowLocation> get(String field) {
        Map<String, List<SearchRowLocation>> byTerm = this.locations.get(field);
        if (byTerm == null) {
            return Collections.emptyList();
        }
        LinkedList<SearchRowLocation> result = new LinkedList<SearchRowLocation>();
        for (List<SearchRowLocation> termList : byTerm.values()) {
            result.addAll(termList);
        }
        return result;
    }

    public List<SearchRowLocation> get(String field, String term) {
        Map<String, List<SearchRowLocation>> byTerm = this.locations.get(field);
        if (byTerm == null) {
            return Collections.emptyList();
        }
        List<SearchRowLocation> result = byTerm.get(term);
        if (result == null) {
            return Collections.emptyList();
        }
        return new ArrayList<SearchRowLocation>(result);
    }

    public List<SearchRowLocation> getAll() {
        LinkedList<SearchRowLocation> all = new LinkedList<SearchRowLocation>();
        for (Map.Entry<String, Map<String, List<SearchRowLocation>>> terms : this.locations.entrySet()) {
            for (List<SearchRowLocation> rowLocations : terms.getValue().values()) {
                all.addAll(rowLocations);
            }
        }
        return all;
    }

    public List<String> fields() {
        return new ArrayList<String>(this.locations.keySet());
    }

    public List<String> termsFor(String field) {
        Map<String, List<SearchRowLocation>> termMap = this.locations.get(field);
        if (termMap == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(termMap.keySet());
    }

    public Set<String> terms() {
        HashSet<String> termSet = new HashSet<String>();
        for (Map<String, List<SearchRowLocation>> termMap : this.locations.values()) {
            termSet.addAll(termMap.keySet());
        }
        return termSet;
    }

    public static SearchRowLocations from(JsonObject locationsJson) {
        SearchRowLocations hitLocations = new SearchRowLocations();
        if (locationsJson == null) {
            return hitLocations;
        }
        for (String field : locationsJson.getNames()) {
            JsonObject termsJson = locationsJson.getObject(field);
            for (String term : termsJson.getNames()) {
                JsonArray locsJson = termsJson.getArray(term);
                for (int i = 0; i < locsJson.size(); ++i) {
                    JsonObject loc = locsJson.getObject(i);
                    long pos = loc.getLong("pos");
                    long start = loc.getLong("start");
                    long end = loc.getLong("end");
                    JsonArray arrayPositionsJson = loc.getArray("array_positions");
                    long[] arrayPositions = null;
                    if (arrayPositionsJson != null) {
                        arrayPositions = new long[arrayPositionsJson.size()];
                        for (int j = 0; j < arrayPositionsJson.size(); ++j) {
                            arrayPositions[j] = arrayPositionsJson.getLong(j);
                        }
                    }
                    hitLocations.add(new SearchRowLocation(field, term, pos, start, end, arrayPositions));
                }
            }
        }
        return hitLocations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SearchRowLocations{").append("size=").append(this.size).append(", locations=[");
        for (Map<String, List<SearchRowLocation>> map : this.locations.values()) {
            for (List<SearchRowLocation> rowLocations : map.values()) {
                for (SearchRowLocation rowLocation : rowLocations) {
                    sb.append(rowLocation).append(",");
                }
            }
        }
        if (!this.locations.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]}");
        return sb.toString();
    }
}

