/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions.internal;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.error.EncodingFailureException;
import com.couchbase.client.core.error.UnambiguousTimeoutException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.query.QueryResponse;
import com.couchbase.client.core.transaction.CoreTransactionsReactive;
import com.couchbase.client.core.transaction.config.CoreSingleQueryTransactionOptions;
import com.couchbase.client.core.transaction.config.CoreTransactionsConfig;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import com.couchbase.client.core.transaction.support.SpanWrapperUtil;
import com.couchbase.client.core.transaction.support.TransactionAttemptContextFactory;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import com.couchbase.client.java.query.ReactiveQueryResult;
import com.couchbase.client.java.transactions.error.TransactionExpiredException;
import com.couchbase.client.java.transactions.internal.ErrorUtil;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class SingleQueryTransactions {
    public static Mono<QueryResult> singleQueryTransactionBuffered(Core core, ClusterEnvironment environment, String statement, @Nullable String bucketName, @Nullable String scopeName, QueryOptions.Built opts) {
        if (opts.retryStrategy().isPresent()) {
            throw new IllegalArgumentException("Cannot specify retryStrategy() if using asTransaction() on QueryOptions");
        }
        CoreTransactionsReactive tri = SingleQueryTransactions.configureTransactions(core, opts);
        JsonObject json = JsonObject.create();
        opts.injectParams(json);
        try {
            SpanWrapper span = SpanWrapperUtil.createOp(null, (RequestTracer)core.context().environment().requestTracer(), null, null, (String)"query", (SpanWrapper)opts.parentSpan().map(SpanWrapper::new).orElse(null)).attribute("db.statement", (Object)statement).attribute("db.couchbase.transaction.single_query", (Object)true);
            ObjectNode converted = (ObjectNode)Mapper.reader().readValue(json.toBytes(), ObjectNode.class);
            JsonSerializer serializer = opts.serializer() == null ? environment.jsonSerializer() : opts.serializer();
            return tri.queryBlocking(statement, bucketName, scopeName, converted, Optional.of(span.span())).map(qr -> new QueryResult(qr.header, qr.rows, qr.trailer, serializer)).onErrorResume(ErrorUtil::convertTransactionFailedInternal).onErrorResume(ex -> {
                if (ex instanceof TransactionExpiredException) {
                    return Mono.error((Throwable)new UnambiguousTimeoutException(ex.getMessage(), null));
                }
                return Mono.error((Throwable)ex);
            }).doOnError(err -> span.finish(err)).doOnTerminate(() -> span.finish());
        }
        catch (IOException e) {
            return Mono.error((Throwable)new EncodingFailureException((Throwable)e));
        }
    }

    private static CoreTransactionsReactive configureTransactions(Core core, QueryOptions.Built opts) {
        CoreSingleQueryTransactionOptions queryOpts = opts.asTransactionOptions();
        CoreTransactionsConfig transactionsConfig = core.context().environment().transactionsConfig();
        return new CoreTransactionsReactive(core, CoreTransactionsConfig.createForSingleQueryTransactions((DurabilityLevel)(queryOpts == null ? transactionsConfig.durabilityLevel() : queryOpts.durabilityLevel().orElse(transactionsConfig.durabilityLevel())), (Duration)opts.timeout().orElse(transactionsConfig.transactionExpirationTime()), (TransactionAttemptContextFactory)(queryOpts == null ? null : queryOpts.attemptContextFactory().orElse(transactionsConfig.attemptContextFactory())), (Optional)(queryOpts == null ? transactionsConfig.metadataCollection() : queryOpts.metadataCollection())));
    }

    public static Mono<ReactiveQueryResult> singleQueryTransactionStreaming(Core core, ClusterEnvironment environment, String statement, @Nullable String bucketName, @Nullable String scopeName, QueryOptions.Built opts, Consumer<RuntimeException> errorConverter) {
        if (opts.retryStrategy().isPresent()) {
            throw new IllegalArgumentException("Cannot specify retryStrategy() if using asTransaction() on QueryOptions");
        }
        CoreTransactionsReactive tri = SingleQueryTransactions.configureTransactions(core, opts);
        JsonObject json = JsonObject.create();
        opts.injectParams(json);
        try {
            SpanWrapper span = SpanWrapperUtil.createOp(null, (RequestTracer)core.context().environment().requestTracer(), null, null, (String)"query", (SpanWrapper)opts.parentSpan().map(SpanWrapper::new).orElse(null)).attribute("db.statement", (Object)statement).attribute("db.couchbase.transaction.single_query", (Object)true);
            ObjectNode converted = (ObjectNode)Mapper.reader().readValue(json.toBytes(), ObjectNode.class);
            JsonSerializer serializer = opts.serializer() == null ? environment.jsonSerializer() : opts.serializer();
            return tri.query(statement, bucketName, scopeName, converted, Optional.of(span.span()), errorConverter).map(qr -> new ReactiveQueryResult((QueryResponse)qr, serializer)).onErrorResume(ErrorUtil::convertTransactionFailedInternal).doOnError(err -> span.finish(err)).doOnTerminate(() -> span.finish());
        }
        catch (IOException e) {
            return Mono.error((Throwable)new EncodingFailureException((Throwable)e));
        }
    }
}

