/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.facet;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.facet.CoreDateRange;
import com.couchbase.client.core.api.search.facet.CoreSearchFacet;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.Validators;
import java.util.List;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreDateRangeFacet
extends CoreSearchFacet {
    private final List<CoreDateRange> dateRanges;

    public CoreDateRangeFacet(String field, @Nullable Integer limit, List<CoreDateRange> dateRanges) {
        super(field, limit);
        this.dateRanges = Validators.notNullOrEmpty(dateRanges, "Date Ranges");
    }

    public List<CoreDateRange> dateRanges() {
        return this.dateRanges;
    }

    @Override
    public void injectParams(ObjectNode queryJson) {
        super.injectParams(queryJson);
        ArrayNode dateRange = Mapper.createArrayNode();
        for (CoreDateRange dr : this.dateRanges) {
            ObjectNode drJson = Mapper.createObjectNode();
            drJson.put("name", dr.name());
            if (dr.start() != null) {
                drJson.put("start", dr.start());
            }
            if (dr.end() != null) {
                drJson.put("end", dr.end());
            }
            dateRange.add(drJson);
        }
        queryJson.set("date_ranges", dateRange);
    }
}

