/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.facet;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.facet.CoreNumericRange;
import com.couchbase.client.core.api.search.facet.CoreSearchFacet;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.json.Mapper;
import java.util.List;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreNumericRangeFacet
extends CoreSearchFacet {
    private final List<CoreNumericRange> ranges;

    public CoreNumericRangeFacet(String field, @Nullable Integer limit, List<CoreNumericRange> ranges) {
        super(field, limit);
        this.ranges = ranges;
    }

    public List<CoreNumericRange> ranges() {
        return this.ranges;
    }

    @Override
    public void injectParams(ObjectNode queryJson) {
        super.injectParams(queryJson);
        ArrayNode numericRange = Mapper.createArrayNode();
        for (CoreNumericRange nr : this.ranges) {
            ObjectNode nrJson = Mapper.createObjectNode();
            nrJson.put("name", nr.name());
            if (nr.min() != null) {
                nrJson.put("min", nr.min());
            }
            if (nr.max() != null) {
                nrJson.put("max", nr.max());
            }
            numericRange.add(nrJson);
        }
        queryJson.set("numeric_ranges", numericRange);
    }
}

