/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.protostellar.search.v1.Query;
import com.couchbase.client.protostellar.search.v1.TermRangeQuery;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreTermRangeQuery
extends CoreSearchQuery {
    @Nullable
    private final String min;
    @Nullable
    private final String max;
    @Nullable
    private final Boolean inclusiveMin;
    @Nullable
    private final Boolean inclusiveMax;
    @Nullable
    private final String field;

    public CoreTermRangeQuery(@Nullable String min, @Nullable String max, @Nullable Boolean inclusiveMin, @Nullable Boolean inclusiveMax, @Nullable String field, @Nullable Double boost) {
        super(boost);
        this.min = min;
        this.max = max;
        this.inclusiveMin = inclusiveMin;
        this.inclusiveMax = inclusiveMax;
        this.field = field;
    }

    @Override
    protected void injectParams(ObjectNode input) {
        if (this.min == null && this.max == null) {
            throw new NullPointerException("TermRangeQuery needs at least one of min or max");
        }
        if (this.min != null) {
            input.put("min", this.min);
            if (this.inclusiveMin != null) {
                input.put("inclusive_min", this.inclusiveMin);
            }
        }
        if (this.max != null) {
            input.put("max", this.max);
            if (this.inclusiveMax != null) {
                input.put("inclusive_max", this.inclusiveMax);
            }
        }
        if (this.field != null) {
            input.put("field", this.field);
        }
    }

    @Override
    public Query asProtostellar() {
        TermRangeQuery.Builder builder = TermRangeQuery.newBuilder();
        if (this.min != null) {
            builder.setMin(this.min);
            if (this.inclusiveMin != null) {
                builder.setInclusiveMin(this.inclusiveMin);
            }
        }
        if (this.max != null) {
            builder.setMax(this.max);
            if (this.inclusiveMax != null) {
                builder.setInclusiveMax(this.inclusiveMax);
            }
        }
        if (this.field != null) {
            builder.setField(this.field);
        }
        if (this.boost != null) {
            builder.setBoost(this.boost.floatValue());
        }
        return Query.newBuilder().setTermRangeQuery(builder).build();
    }
}

