/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node;

import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Objects;

public class NodeIdentifier {
    private final String address;
    private final int managerPort;

    public NodeIdentifier(String address, int managerPort) {
        this.address = address;
        this.managerPort = managerPort;
    }

    public String address() {
        return this.address;
    }

    public int managerPort() {
        return this.managerPort;
    }

    public String toString() {
        return "NodeIdentifier{address=" + RedactableArgument.redactSystem(this.address) + ", managerPort=" + RedactableArgument.redactSystem(this.managerPort) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeIdentifier that = (NodeIdentifier)o;
        return this.managerPort == that.managerPort && Objects.equals(this.address, that.address);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.managerPort);
    }
}

