/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar.manager;

import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.config.BucketType;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.BucketNotFoundException;
import com.couchbase.client.core.manager.CoreBucketManagerOps;
import com.couchbase.client.core.manager.bucket.CoreBucketSettings;
import com.couchbase.client.core.manager.bucket.CoreCompressionMode;
import com.couchbase.client.core.manager.bucket.CoreCreateBucketSettings;
import com.couchbase.client.core.manager.bucket.CoreEvictionPolicyType;
import com.couchbase.client.core.manager.bucket.CoreStorageBackend;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.protostellar.CoreProtostellarAccessors;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.protostellar.manager.ProtostellarCoreBucketManagerRequests;
import com.couchbase.client.protostellar.admin.bucket.v1.BucketAdminServiceGrpc;
import com.couchbase.client.protostellar.admin.bucket.v1.CreateBucketRequest;
import com.couchbase.client.protostellar.admin.bucket.v1.DeleteBucketRequest;
import com.couchbase.client.protostellar.admin.bucket.v1.ListBucketsRequest;
import com.couchbase.client.protostellar.admin.bucket.v1.ListBucketsResponse;
import com.couchbase.client.protostellar.admin.bucket.v1.UpdateBucketRequest;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class ProtostellarCoreBucketManager
implements CoreBucketManagerOps {
    private final CoreProtostellar core;

    public ProtostellarCoreBucketManager(CoreProtostellar core) {
        this.core = Objects.requireNonNull(core);
    }

    @Override
    public CompletableFuture<Void> createBucket(CoreBucketSettings settings, @Nullable CoreCreateBucketSettings createSpecificSettings, CoreCommonOptions options) {
        ProtostellarRequest<CreateBucketRequest> request = ProtostellarCoreBucketManagerRequests.createBucketRequest(this.core, settings, createSpecificSettings, options);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((BucketAdminServiceGrpc.BucketAdminServiceFutureStub)endpoint.bucketAdminStub().withDeadline(request.deadline())).createBucket((CreateBucketRequest)request.request()), response -> null).thenApply(obj -> null);
    }

    @Override
    public CompletableFuture<Void> updateBucket(CoreBucketSettings settings, CoreCommonOptions options) {
        ProtostellarRequest<UpdateBucketRequest> request = ProtostellarCoreBucketManagerRequests.updateBucketRequest(this.core, settings, options);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((BucketAdminServiceGrpc.BucketAdminServiceFutureStub)endpoint.bucketAdminStub().withDeadline(request.deadline())).updateBucket((UpdateBucketRequest)request.request()), response -> null).thenApply(obj -> null);
    }

    @Override
    public CompletableFuture<Void> dropBucket(String bucketName, CoreCommonOptions options) {
        ProtostellarRequest<DeleteBucketRequest> request = ProtostellarCoreBucketManagerRequests.deleteBucketRequest(this.core, bucketName, options);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((BucketAdminServiceGrpc.BucketAdminServiceFutureStub)endpoint.bucketAdminStub().withDeadline(request.deadline())).deleteBucket((DeleteBucketRequest)request.request()), response -> null).thenApply(obj -> null);
    }

    @Override
    public CompletableFuture<CoreBucketSettings> getBucket(String bucketName, CoreCommonOptions options) {
        return this.getAllBuckets(options).thenApply(buckets -> {
            if (!buckets.containsKey(bucketName)) {
                throw new BucketNotFoundException(bucketName);
            }
            return (CoreBucketSettings)buckets.get(bucketName);
        });
    }

    @Override
    public CompletableFuture<Map<String, CoreBucketSettings>> getAllBuckets(CoreCommonOptions options) {
        ProtostellarRequest<ListBucketsRequest> request = ProtostellarCoreBucketManagerRequests.listBucketsRequest(this.core, options);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((BucketAdminServiceGrpc.BucketAdminServiceFutureStub)endpoint.bucketAdminStub().withDeadline(request.deadline())).listBuckets((ListBucketsRequest)request.request()), response -> {
            HashMap out = new HashMap();
            response.getBucketsList().forEach(bucket -> out.put(bucket.getBucketName(), ProtostellarCoreBucketManager.extracted(bucket)));
            return out;
        }).thenApply(v -> v);
    }

    private static CoreBucketSettings extracted(final ListBucketsResponse.Bucket bucket) {
        return new CoreBucketSettings(){

            @Override
            public String name() {
                return bucket.getBucketName();
            }

            @Override
            public Boolean flushEnabled() {
                return bucket.getFlushEnabled();
            }

            @Override
            public long ramQuotaMB() {
                return bucket.getRamQuotaBytes() / 1000000L;
            }

            @Override
            public Integer numReplicas() {
                return bucket.getNumReplicas();
            }

            @Override
            public Boolean replicaIndexes() {
                return bucket.getReplicaIndexes();
            }

            @Override
            public BucketType bucketType() {
                switch (bucket.getBucketType()) {
                    case BUCKET_TYPE_COUCHBASE: {
                        return BucketType.COUCHBASE;
                    }
                    case BUCKET_TYPE_MEMCACHED: {
                        return BucketType.MEMCACHED;
                    }
                    case BUCKET_TYPE_EPHEMERAL: {
                        return BucketType.EPHEMERAL;
                    }
                }
                throw CoreProtostellarUtil.incompatibleProtostellar("Unknown bucket type " + bucket.getBucketType());
            }

            @Override
            public CoreEvictionPolicyType evictionPolicy() {
                switch (bucket.getEvictionMode()) {
                    case EVICTION_MODE_FULL: {
                        return CoreEvictionPolicyType.FULL;
                    }
                    case EVICTION_MODE_NOT_RECENTLY_USED: {
                        return CoreEvictionPolicyType.NOT_RECENTLY_USED;
                    }
                    case EVICTION_MODE_VALUE_ONLY: {
                        return CoreEvictionPolicyType.VALUE_ONLY;
                    }
                    case EVICTION_MODE_NONE: {
                        return CoreEvictionPolicyType.NO_EVICTION;
                    }
                }
                throw CoreProtostellarUtil.incompatibleProtostellar("Unknown eviction policy " + bucket.getEvictionMode());
            }

            @Override
            public Duration maxExpiry() {
                return Duration.ofSeconds(bucket.getMaxExpirySecs());
            }

            @Override
            public CoreCompressionMode compressionMode() {
                switch (bucket.getCompressionMode()) {
                    case COMPRESSION_MODE_OFF: {
                        return CoreCompressionMode.OFF;
                    }
                    case COMPRESSION_MODE_PASSIVE: {
                        return CoreCompressionMode.PASSIVE;
                    }
                    case COMPRESSION_MODE_ACTIVE: {
                        return CoreCompressionMode.ACTIVE;
                    }
                }
                throw CoreProtostellarUtil.incompatibleProtostellar("Unknown compression mode " + bucket.getCompressionMode());
            }

            @Override
            public DurabilityLevel minimumDurabilityLevel() {
                switch (bucket.getMinimumDurabilityLevel()) {
                    case DURABILITY_LEVEL_MAJORITY: {
                        return DurabilityLevel.MAJORITY;
                    }
                    case DURABILITY_LEVEL_MAJORITY_AND_PERSIST_TO_ACTIVE: {
                        return DurabilityLevel.MAJORITY_AND_PERSIST_TO_ACTIVE;
                    }
                    case DURABILITY_LEVEL_PERSIST_TO_MAJORITY: {
                        return DurabilityLevel.PERSIST_TO_MAJORITY;
                    }
                }
                throw CoreProtostellarUtil.incompatibleProtostellar("Unknown min durability level " + bucket.getMinimumDurabilityLevel());
            }

            @Override
            public CoreStorageBackend storageBackend() {
                switch (bucket.getStorageBackend()) {
                    case STORAGE_BACKEND_COUCHSTORE: {
                        return CoreStorageBackend.COUCHSTORE;
                    }
                    case STORAGE_BACKEND_MAGMA: {
                        return CoreStorageBackend.MAGMA;
                    }
                }
                throw CoreProtostellarUtil.incompatibleProtostellar("Unknown storage backend " + bucket.getStorageBackend());
            }

            @Override
            public Boolean historyRetentionCollectionDefault() {
                return null;
            }

            @Override
            public Long historyRetentionBytes() {
                return null;
            }

            @Override
            public Duration historyRetentionDuration() {
                return null;
            }
        };
    }

    @Override
    public CompletableFuture<Void> flushBucket(String bucketName, CoreCommonOptions options) {
        throw CoreProtostellarUtil.unsupportedInProtostellar("flushing buckets");
    }
}

