/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.retry;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.diagnostics.AuthenticationStatus;
import com.couchbase.client.core.diagnostics.InternalEndpointDiagnostics;
import com.couchbase.client.core.service.ServiceType;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Stability.Internal
public class AuthErrorDecider {
    public static boolean isAuthError(List<InternalEndpointDiagnostics> endpointDiagnostics) {
        return endpointDiagnostics.stream().anyMatch(ed -> ed.internal.type() == ServiceType.KV && !ed.internal.namespace().isPresent() && ed.authenticationStatus == AuthenticationStatus.FAILED);
    }

    public static boolean isAuthError(Stream<InternalEndpointDiagnostics> endpointDiagnostics) {
        return AuthErrorDecider.isAuthError(endpointDiagnostics.collect(Collectors.toList()));
    }
}

