/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.atr;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.node.KeyValueLocator;
import com.couchbase.client.core.util.CbPreconditions;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;

@Stability.Internal
public class ActiveTransactionRecordIds {
    public static final int NUM_VBUCKETS = 1024;
    public static final int NUM_ATRS_DEFAULT = 1024;
    public static final int MAX_ATR_BLOCKS = 20;
    public static final int MAX_ATRS = 20480;
    private static List<String> ATR_IDS;

    private ActiveTransactionRecordIds() {
    }

    public static List<String> allAtrs(int numAtrs) {
        return ATR_IDS.stream().limit(numAtrs).collect(Collectors.toList());
    }

    public static List<String> atrIdsForVbucket(int vbucketId, int numAtrs) {
        CbPreconditions.check(vbucketId >= 0);
        CbPreconditions.check(vbucketId < 1024);
        ArrayList<String> out = new ArrayList<String>();
        for (int i = vbucketId; i < numAtrs; i += 1024) {
            out.add(ATR_IDS.get(i));
        }
        return out;
    }

    public static String randomAtrIdForVbucket(int vbucketId, int numAtrs) {
        List<String> possibilities = ActiveTransactionRecordIds.atrIdsForVbucket(vbucketId, numAtrs);
        int index = ThreadLocalRandom.current().nextInt(possibilities.size());
        return possibilities.get(index);
    }

    public static int vbucketForKey(String id, int numPartitions) {
        return KeyValueLocator.partitionForKey(id.getBytes(StandardCharsets.UTF_8), numPartitions);
    }

    static {
        try {
            ArrayList<String> atrIds = new ArrayList<String>();
            try (BufferedReader stream = new BufferedReader(new InputStreamReader(ActiveTransactionRecordIds.class.getResourceAsStream("transaction-atr-ids.txt")));){
                String in;
                while ((in = stream.readLine()) != null) {
                    if (in.startsWith("//") || in.trim().isEmpty()) continue;
                    atrIds.add(in);
                }
            }
            ATR_IDS = Collections.unmodifiableList(atrIds);
        }
        catch (Exception err) {
            throw new RuntimeException("Fatal error loading ATR ids, transactions will not operate", err);
        }
    }
}

