/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.cleanup;

import com.couchbase.client.core.annotation.Stability;
import java.util.List;
import java.util.Objects;

@Stability.Internal
public class ClientRecordDetails {
    private final int numActiveClients;
    private final int indexOfThisClient;
    private final boolean clientIsNew;
    private final List<String> expiredClientIds;
    private final int numExistingClients;
    private final int numExpiredClients;
    private final boolean overrideEnabled;
    private final long overrideExpires;
    private final long casNowNanos;

    public ClientRecordDetails(int numActiveClients, int indexOfThisClient, boolean clientIsNew, List<String> expiredClientIds, int numExistingClients, int numExpiredClients, boolean overrideEnabled, long overrideExpires, long casNowNanos) {
        this.numActiveClients = numActiveClients;
        this.indexOfThisClient = indexOfThisClient;
        this.clientIsNew = clientIsNew;
        this.expiredClientIds = Objects.requireNonNull(expiredClientIds);
        this.numExistingClients = numExistingClients;
        this.numExpiredClients = numExpiredClients;
        this.overrideEnabled = overrideEnabled;
        this.overrideExpires = overrideExpires;
        this.casNowNanos = casNowNanos;
    }

    public int numActiveClients() {
        return this.numActiveClients;
    }

    public int indexOfThisClient() {
        return this.indexOfThisClient;
    }

    public boolean clientIsNew() {
        return this.clientIsNew;
    }

    public List<String> expiredClientIds() {
        return this.expiredClientIds;
    }

    public int numExistingClients() {
        return this.numExistingClients;
    }

    public int numExpiredClients() {
        return this.numExpiredClients;
    }

    public boolean overrideEnabled() {
        return this.overrideEnabled;
    }

    public long overrideExpires() {
        return this.overrideExpires;
    }

    public long casNow() {
        return this.casNowNanos;
    }

    public boolean overrideActive() {
        return this.overrideEnabled && this.casNowNanos < this.overrideExpires;
    }
}

