/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.io.CollectionIdentifier;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Stability.Internal
public class CoreTransactionsCleanupConfig {
    public static final Duration DEFAULT_TRANSACTION_CLEANUP_WINDOW = Duration.ofSeconds(60L);
    public static final String TRANSACTIONS_CLEANUP_LOST_PROPERTY = "com.couchbase.transactions.cleanup.lost.enabled";
    public static final String TRANSACTIONS_CLEANUP_REGULAR_PROPERTY = "com.couchbase.transactions.cleanup.regular.enabled";
    private final boolean runLostAttemptsCleanupThread;
    private final boolean runRegularAttemptsCleanupThread;
    private final Duration cleanupWindow;
    private final Set<CollectionIdentifier> cleanupSet;

    public CoreTransactionsCleanupConfig(boolean runLostAttemptsCleanupThread, boolean runRegularAttemptsCleanupThread, Duration cleanupWindow, Set<CollectionIdentifier> cleanupSet) {
        this.runLostAttemptsCleanupThread = runLostAttemptsCleanupThread;
        this.runRegularAttemptsCleanupThread = runRegularAttemptsCleanupThread;
        this.cleanupWindow = Objects.requireNonNull(cleanupWindow);
        this.cleanupSet = new HashSet<CollectionIdentifier>((Collection)Objects.requireNonNull(cleanupSet));
    }

    @Stability.Internal
    public static CoreTransactionsCleanupConfig createDefault() {
        return new CoreTransactionsCleanupConfig(Boolean.parseBoolean(System.getProperty(TRANSACTIONS_CLEANUP_LOST_PROPERTY, "true")), Boolean.parseBoolean(System.getProperty(TRANSACTIONS_CLEANUP_REGULAR_PROPERTY, "true")), DEFAULT_TRANSACTION_CLEANUP_WINDOW, new HashSet<CollectionIdentifier>());
    }

    public static CoreTransactionsCleanupConfig createForSingleQueryTransactions() {
        return new CoreTransactionsCleanupConfig(false, false, DEFAULT_TRANSACTION_CLEANUP_WINDOW, new HashSet<CollectionIdentifier>());
    }

    public boolean runLostAttemptsCleanupThread() {
        return this.runLostAttemptsCleanupThread;
    }

    public boolean runRegularAttemptsCleanupThread() {
        return this.runRegularAttemptsCleanupThread;
    }

    public Duration cleanupWindow() {
        return this.cleanupWindow;
    }

    public Set<CollectionIdentifier> cleanupSet() {
        return this.cleanupSet;
    }

    Map<String, Object> exportAsMap() {
        LinkedHashMap<String, Object> export = new LinkedHashMap<String, Object>();
        export.put("runLostAttemptsCleanupThread", this.runLostAttemptsCleanupThread);
        export.put("runRegularAttemptsCleanupThread", this.runRegularAttemptsCleanupThread);
        export.put("cleanupWindowMs", this.cleanupWindow.toMillis());
        export.put("cleanupSet", this.cleanupSet.stream().map(CollectionIdentifier::toString).collect(Collectors.joining(",")));
        return export;
    }
}

