/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.threadlocal;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.transaction.threadlocal.TransactionMarker;
import java.util.Optional;
import reactor.core.publisher.Mono;

@Stability.Internal
public class TransactionMarkerOwner {
    private static final ThreadLocal<TransactionMarker> marker = new ThreadLocal();

    public static void set(TransactionMarker toInject) {
        if (marker.get() != null) {
            throw new IllegalStateException("Trying to set transaction context when already inside a transaction - likely an internal bug, please report it");
        }
        marker.set(toInject);
    }

    public static void clear() {
        marker.remove();
    }

    public static Mono<Optional<TransactionMarker>> get() {
        return Mono.deferContextual(ctx -> {
            TransactionMarker fromReactive;
            TransactionMarker fromThreadLocal = marker.get();
            TransactionMarker transactionMarker = fromReactive = ctx.hasKey(TransactionMarker.class) ? (TransactionMarker)ctx.get(TransactionMarker.class) : null;
            if (fromThreadLocal != null) {
                return Mono.just(Optional.of(fromThreadLocal));
            }
            if (fromReactive != null) {
                return Mono.just(Optional.of(fromReactive));
            }
            return Mono.just(Optional.empty());
        });
    }
}

